/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DottedNumber {
    private final List<Integer> nums;
    private final List<String> separators;
    private static final Pattern p = Pattern.compile("(\\d+)|(\\D+)");

    private DottedNumber(List<Integer> nums, List<String> separators) {
        this.nums = nums;
        this.separators = separators;
    }

    public static DottedNumber create(String value) {
        Matcher m = p.matcher(value);
        ArrayList<Integer> nums = new ArrayList<Integer>();
        ArrayList<String> separators = new ArrayList<String>();
        while (m.find()) {
            String part = m.group();
            if (DottedNumber.isDigit(part.charAt(0))) {
                nums.add(Integer.parseInt(part));
                continue;
            }
            separators.add(part);
        }
        return new DottedNumber(nums, separators);
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.nums.size(); ++i) {
            sb.append(this.nums.get(i));
            if (i >= this.separators.size()) continue;
            sb.append(this.separators.get(i));
        }
        return sb.toString();
    }

    public void incrementMinor(int step) {
        int last = this.nums.size() - 1;
        int newValue = this.nums.get(last) + step;
        this.nums.set(last, newValue);
    }

    public void incrementIntermediate() {
        int intermediate = this.nums.size() == 1 ? 0 : this.nums.size() - 2;
        this.incrementIntermediate(intermediate);
    }

    public void incrementIntermediate(int position) {
        int intermediate = position;
        int newValue = this.nums.get(intermediate) + 1;
        for (int i = intermediate + 1; i < this.nums.size(); ++i) {
            this.nums.set(i, 1);
        }
        this.nums.set(intermediate, newValue);
    }

    public String format(DecimalFormat format) {
        if (this.nums.size() == 1 && this.separators.size() == 0) {
            return format.format(this.nums.get(0));
        }
        return "<b>" + this.toString() + "</b>";
    }
}

