/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.security.setting.OpensearchDynamicSetting;

public class CompatConfig {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Settings staticSettings;
    private DynamicConfigModel dcm;
    private final OpensearchDynamicSetting<Boolean> transportPassiveAuthSetting;

    public CompatConfig(Environment environment, OpensearchDynamicSetting<Boolean> transportPassiveAuthSetting) {
        this.staticSettings = environment.settings();
        this.transportPassiveAuthSetting = transportPassiveAuthSetting;
    }

    @Subscribe
    public void onDynamicConfigModelChanged(DynamicConfigModel dcm) {
        this.dcm = dcm;
        this.log.debug("dynamicSecurityConfig updated?: {}", (Object)(dcm != null ? 1 : 0));
    }

    public boolean restAuthEnabled() {
        boolean restInitiallyDisabled = this.staticSettings.getAsBoolean("plugins.security.unsupported.disable_rest_auth_initially", Boolean.valueOf(false));
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (restInitiallyDisabled) {
            if (this.dcm == null) {
                if (isTraceEnabled) {
                    this.log.trace("dynamicSecurityConfig is null, initially static restDisabled");
                }
                return false;
            }
            boolean restDynamicallyDisabled = this.dcm.isRestAuthDisabled();
            if (isTraceEnabled) {
                this.log.trace("opendistro_security.dynamic.disable_rest_auth {}", (Object)restDynamicallyDisabled);
            }
            return !restDynamicallyDisabled;
        }
        return true;
    }

    public boolean transportInterClusterAuthEnabled() {
        boolean interClusterAuthInitiallyDisabled = this.staticSettings.getAsBoolean("plugins.security.unsupported.disable_intertransport_auth_initially", Boolean.valueOf(false));
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (interClusterAuthInitiallyDisabled) {
            if (this.dcm == null) {
                if (isTraceEnabled) {
                    this.log.trace("dynamicSecurityConfig is null, initially static interClusterAuthDisabled");
                }
                return false;
            }
            boolean interClusterAuthDynamicallyDisabled = this.dcm.isInterTransportAuthDisabled();
            if (isTraceEnabled) {
                this.log.trace("plugins.security.dynamic.disable_intertransport_auth {}", (Object)interClusterAuthDynamicallyDisabled);
            }
            return !interClusterAuthDynamicallyDisabled;
        }
        return true;
    }

    public boolean transportInterClusterPassiveAuthEnabled() {
        boolean interClusterAuthInitiallyPassive = this.transportPassiveAuthSetting.getDynamicSettingValue();
        if (this.log.isTraceEnabled()) {
            this.log.trace("{} {}", (Object)"plugins.security.unsupported.passive_intertransport_auth_initially", (Object)interClusterAuthInitiallyPassive);
        }
        return interClusterAuthInitiallyPassive;
    }
}

