/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.passay.dictionary.ArrayWordList;
import org.passay.dictionary.Dictionary;
import org.passay.dictionary.TernaryTree;
import org.passay.dictionary.WordList;
import org.passay.dictionary.WordLists;
import org.passay.dictionary.sort.ArraysSort;

public class TernaryTreeDictionary
implements Dictionary {
    protected final TernaryTree tree;

    public TernaryTreeDictionary(WordList wordList) {
        this(wordList, true);
    }

    public TernaryTreeDictionary(WordList wordList, boolean useMedian) {
        Iterator<String> iterator;
        boolean caseSensitive = wordList.getComparator().compare("A", "a") != 0;
        this.tree = new TernaryTree(caseSensitive);
        Iterator<String> iterator2 = iterator = useMedian ? wordList.medianIterator() : wordList.iterator();
        while (iterator.hasNext()) {
            this.tree.insert(iterator.next());
        }
    }

    public TernaryTreeDictionary(TernaryTree tt) {
        this.tree = tt;
    }

    @Override
    public long size() {
        return this.tree == null ? 0L : (long)this.tree.getWords().size();
    }

    @Override
    public boolean search(String word) {
        return this.tree.search(word);
    }

    public String[] partialSearch(String word) {
        return this.tree.partialSearch(word);
    }

    public String[] nearSearch(String word, int distance) {
        return this.tree.nearSearch(word, distance);
    }

    public TernaryTree getTernaryTree() {
        return this.tree;
    }

    public static void main(String[] args) throws Exception {
        block20: {
            ArrayList<FileReader> files = new ArrayList<FileReader>();
            try {
                if (args.length == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                boolean useMedian = false;
                boolean caseSensitive = true;
                boolean search = false;
                boolean partialSearch = false;
                boolean nearSearch = false;
                boolean print = false;
                boolean printPath = false;
                boolean stats = false;
                String word = null;
                int distance = 0;
                for (int i = 0; i < args.length; ++i) {
                    if ("-m".equals(args[i])) {
                        useMedian = true;
                        continue;
                    }
                    if ("-ci".equals(args[i])) {
                        caseSensitive = false;
                        continue;
                    }
                    if ("-s".equals(args[i])) {
                        search = true;
                        word = args[++i];
                        continue;
                    }
                    if ("-ps".equals(args[i])) {
                        partialSearch = true;
                        word = args[++i];
                        continue;
                    }
                    if ("-ns".equals(args[i])) {
                        nearSearch = true;
                        word = args[++i];
                        distance = Integer.parseInt(args[++i]);
                        continue;
                    }
                    if ("-p".equals(args[i])) {
                        print = true;
                        continue;
                    }
                    if ("-pp".equals(args[i])) {
                        printPath = true;
                        continue;
                    }
                    if ("-st".equals(args[i])) {
                        stats = true;
                        continue;
                    }
                    if ("-h".equals(args[i])) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    files.add(new FileReader(args[i]));
                }
                ArrayWordList awl = WordLists.createFromReader(files.toArray(new FileReader[files.size()]), caseSensitive, new ArraysSort());
                TernaryTreeDictionary dict = new TernaryTreeDictionary(awl, useMedian);
                if (search) {
                    if (dict.search(word)) {
                        System.out.println(String.format("%s was found in this dictionary", word));
                    } else {
                        System.out.println(String.format("%s was not found in this dictionary", word));
                    }
                    break block20;
                }
                if (partialSearch) {
                    String[] matches = dict.partialSearch(word);
                    System.out.println(String.format("Found %s matches for %s in this dictionary : %s", matches.length, word, Arrays.asList(matches)));
                    break block20;
                }
                if (nearSearch) {
                    String[] matches = dict.nearSearch(word, distance);
                    System.out.println(String.format("Found %s matches for %s in this dictionary at a distance of %s : %s", matches.length, word, distance, Arrays.asList(matches)));
                    break block20;
                }
                if (print || printPath) {
                    dict.getTernaryTree().print(new PrintWriter(System.out, true), printPath);
                    break block20;
                }
                if (stats) {
                    System.out.println("word path depths histogram:");
                    System.out.println(dict.getTernaryTree().getNodeStats());
                    break block20;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("Usage: java " + TernaryTreeDictionary.class.getName());
                System.out.println("            <dict1> [... <dictN>] [options] <operation>");
                System.out.println();
                System.out.println("Where <dict1>...<dictN> are files containing dictionary words.");
                System.out.println();
                System.out.println("Options:");
                System.out.println("    -m  insert dictionary using its median");
                System.out.println("    -ci make search case-insensitive");
                System.out.println();
                System.out.println("Operations:");
                System.out.println("    -s  <word>");
                System.out.println("        search for a word");
                System.out.println("    -ps <word>");
                System.out.println("        partial search for a word (with wildcards, e.g. '.a.a.a')");
                System.out.println("    -ns <word> <distance>");
                System.out.println("        near search for a word");
                System.out.println("    -p  print the entire dictionary in tree form, path suffixes only");
                System.out.println("    -pp print the entire dictionary in tree form, full paths");
                System.out.println("    -st print the tree node depth statistics");
                System.out.println("    -h  print this help message");
                System.exit(1);
            }
        }
    }
}

