/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.model;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.reportsscheduler.model.ReportDefinition;
import org.opensearch.reportsscheduler.util.HelpersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 12\u00020\u0001:\u00011B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u001c\u0010\u0018\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u0003H\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\t\u0010)\u001a\u00020\u000bH\u00c6\u0003JK\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010+\u001a\u00020#2\b\u0010,\u001a\u0004\u0018\u00010-H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00062"}, d2={"Lorg/opensearch/reportsscheduler/model/ReportDefinitionDetails;", "Lorg/opensearch/jobscheduler/spi/ScheduledJobParameter;", "id", "", "updatedTime", "Ljava/time/Instant;", "createdTime", "tenant", "access", "", "reportDefinition", "Lorg/opensearch/reportsscheduler/model/ReportDefinition;", "<init>", "(Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Ljava/util/List;Lorg/opensearch/reportsscheduler/model/ReportDefinition;)V", "getId", "()Ljava/lang/String;", "getUpdatedTime", "()Ljava/time/Instant;", "getCreatedTime", "getTenant", "getAccess", "()Ljava/util/List;", "getReportDefinition", "()Lorg/opensearch/reportsscheduler/model/ReportDefinition;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "builder", "getName", "getLastUpdateTime", "getEnabledTime", "getSchedule", "Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "isEnabled", "", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "opensearch-reports-scheduler"})
public final class ReportDefinitionDetails
implements ScheduledJobParameter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final Instant updatedTime;
    @NotNull
    private final Instant createdTime;
    @NotNull
    private final String tenant;
    @NotNull
    private final List<String> access;
    @NotNull
    private final ReportDefinition reportDefinition;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(ReportDefinitionDetails.class);

    public ReportDefinitionDetails(@NotNull String id, @NotNull Instant updatedTime, @NotNull Instant createdTime, @NotNull String tenant, @NotNull List<String> access, @NotNull ReportDefinition reportDefinition) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)updatedTime, (String)"updatedTime");
        Intrinsics.checkNotNullParameter((Object)createdTime, (String)"createdTime");
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)reportDefinition, (String)"reportDefinition");
        this.id = id;
        this.updatedTime = updatedTime;
        this.createdTime = createdTime;
        this.tenant = tenant;
        this.access = access;
        this.reportDefinition = reportDefinition;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Instant getUpdatedTime() {
        return this.updatedTime;
    }

    @NotNull
    public final Instant getCreatedTime() {
        return this.createdTime;
    }

    @NotNull
    public final String getTenant() {
        return this.tenant;
    }

    @NotNull
    public final List<String> getAccess() {
        return this.access;
    }

    @NotNull
    public final ReportDefinition getReportDefinition() {
        return this.reportDefinition;
    }

    @Nullable
    public final XContentBuilder toXContent(@NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.toXContent(XContentFactory.jsonBuilder(), params);
    }

    public static /* synthetic */ XContentBuilder toXContent$default(ReportDefinitionDetails reportDefinitionDetails, ToXContent.Params params, int n, Object object) {
        if ((n & 1) != 0) {
            ToXContent.Params params2 = ToXContent.EMPTY_PARAMS;
            Intrinsics.checkNotNullExpressionValue((Object)params2, (String)"EMPTY_PARAMS");
            params = params2;
        }
        return reportDefinitionDetails.toXContent(params);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        builder.startObject();
        ToXContent.Params params2 = params;
        boolean bl = params2 != null ? params2.paramAsBoolean("id", false) : false;
        if (bl) {
            builder.field("id", this.id);
        }
        builder.field("lastUpdatedTimeMs", this.updatedTime.toEpochMilli()).field("createdTimeMs", this.createdTime.toEpochMilli()).field("tenant", this.tenant);
        ToXContent.Params params3 = params;
        boolean bl2 = params3 != null ? params3.paramAsBoolean("access", true) : false;
        if (bl2 && !((Collection)this.access).isEmpty()) {
            builder.field("access", (Iterable)this.access);
        }
        builder.field("reportDefinition");
        this.reportDefinition.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    @NotNull
    public String getName() {
        return this.reportDefinition.getName();
    }

    @NotNull
    public Instant getLastUpdateTime() {
        return this.updatedTime;
    }

    @NotNull
    public Instant getEnabledTime() {
        return this.createdTime;
    }

    @NotNull
    public Schedule getSchedule() {
        Schedule schedule = this.reportDefinition.getTrigger().getSchedule();
        Intrinsics.checkNotNull((Object)schedule);
        return schedule;
    }

    public boolean isEnabled() {
        ReportDefinition.Trigger trigger = this.reportDefinition.getTrigger();
        return this.reportDefinition.isEnabled() && this.reportDefinition.getTrigger().getSchedule() != null && (trigger.getTriggerType() == ReportDefinition.TriggerType.IntervalSchedule || trigger.getTriggerType() == ReportDefinition.TriggerType.CronSchedule);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final Instant component2() {
        return this.updatedTime;
    }

    @NotNull
    public final Instant component3() {
        return this.createdTime;
    }

    @NotNull
    public final String component4() {
        return this.tenant;
    }

    @NotNull
    public final List<String> component5() {
        return this.access;
    }

    @NotNull
    public final ReportDefinition component6() {
        return this.reportDefinition;
    }

    @NotNull
    public final ReportDefinitionDetails copy(@NotNull String id, @NotNull Instant updatedTime, @NotNull Instant createdTime, @NotNull String tenant, @NotNull List<String> access, @NotNull ReportDefinition reportDefinition) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)updatedTime, (String)"updatedTime");
        Intrinsics.checkNotNullParameter((Object)createdTime, (String)"createdTime");
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)reportDefinition, (String)"reportDefinition");
        return new ReportDefinitionDetails(id, updatedTime, createdTime, tenant, access, reportDefinition);
    }

    public static /* synthetic */ ReportDefinitionDetails copy$default(ReportDefinitionDetails reportDefinitionDetails, String string, Instant instant, Instant instant2, String string2, List list, ReportDefinition reportDefinition, int n, Object object) {
        if ((n & 1) != 0) {
            string = reportDefinitionDetails.id;
        }
        if ((n & 2) != 0) {
            instant = reportDefinitionDetails.updatedTime;
        }
        if ((n & 4) != 0) {
            instant2 = reportDefinitionDetails.createdTime;
        }
        if ((n & 8) != 0) {
            string2 = reportDefinitionDetails.tenant;
        }
        if ((n & 0x10) != 0) {
            list = reportDefinitionDetails.access;
        }
        if ((n & 0x20) != 0) {
            reportDefinition = reportDefinitionDetails.reportDefinition;
        }
        return reportDefinitionDetails.copy(string, instant, instant2, string2, list, reportDefinition);
    }

    @NotNull
    public String toString() {
        return "ReportDefinitionDetails(id=" + this.id + ", updatedTime=" + this.updatedTime + ", createdTime=" + this.createdTime + ", tenant=" + this.tenant + ", access=" + this.access + ", reportDefinition=" + this.reportDefinition + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.updatedTime.hashCode();
        result = result * 31 + this.createdTime.hashCode();
        result = result * 31 + this.tenant.hashCode();
        result = result * 31 + ((Object)this.access).hashCode();
        result = result * 31 + this.reportDefinition.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReportDefinitionDetails)) {
            return false;
        }
        ReportDefinitionDetails reportDefinitionDetails = (ReportDefinitionDetails)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)reportDefinitionDetails.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.updatedTime, (Object)reportDefinitionDetails.updatedTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.createdTime, (Object)reportDefinitionDetails.createdTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tenant, (Object)reportDefinitionDetails.tenant)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.access, reportDefinitionDetails.access)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.reportDefinition, (Object)reportDefinitionDetails.reportDefinition);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/opensearch/reportsscheduler/model/ReportDefinitionDetails$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "parse", "Lorg/opensearch/reportsscheduler/model/ReportDefinitionDetails;", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "useId", "", "opensearch-reports-scheduler"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final ReportDefinitionDetails parse(@NotNull XContentParser parser, @Nullable String useId) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            String id = useId;
            Instant updatedTime = null;
            Instant createdTime = null;
            String tenant = null;
            List<String> access = CollectionsKt.emptyList();
            ReportDefinition reportDefinition = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block16: while (XContentParser.Token.END_OBJECT != parser.nextToken()) {
                String fieldName;
                block28: {
                    fieldName = parser.currentName();
                    parser.nextToken();
                    String string = fieldName;
                    if (string == null) break block28;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 1098216871: {
                            if (string.equals("reportDefinition")) {
                                n = 1;
                            }
                            break;
                        }
                        case -394530056: {
                            if (string.equals("lastUpdatedTimeMs")) {
                                n = 2;
                            }
                            break;
                        }
                        case -1423461020: {
                            if (string.equals("access")) {
                                n = 3;
                            }
                            break;
                        }
                        case 1643084379: {
                            if (string.equals("createdTimeMs")) {
                                n = 4;
                            }
                            break;
                        }
                        case 3355: {
                            if (string.equals("id")) {
                                n = 5;
                            }
                            break;
                        }
                        case -877336406: {
                            if (string.equals("tenant")) {
                                n = 6;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 5: {
                            id = parser.text();
                            continue block16;
                        }
                        case 2: {
                            updatedTime = Instant.ofEpochMilli(parser.longValue());
                            continue block16;
                        }
                        case 4: {
                            createdTime = Instant.ofEpochMilli(parser.longValue());
                            continue block16;
                        }
                        case 6: {
                            tenant = parser.text();
                            continue block16;
                        }
                        case 3: {
                            access = HelpersKt.stringList(parser);
                            continue block16;
                        }
                        case 1: {
                            reportDefinition = ReportDefinition.Companion.parse(parser);
                            continue block16;
                        }
                    }
                }
                parser.skipChildren();
                this.getLog().info("reports:ReportDefinitionDetails Skipping Unknown field " + fieldName);
            }
            if (id == null) {
                throw new IllegalArgumentException("id field absent");
            }
            if (updatedTime == null) {
                throw new IllegalArgumentException("lastUpdatedTimeMs field absent");
            }
            if (createdTime == null) {
                throw new IllegalArgumentException("createdTimeMs field absent");
            }
            String string = tenant;
            if (string == null) {
                string = tenant = "";
            }
            if (reportDefinition == null) {
                throw new IllegalArgumentException("reportDefinition field absent");
            }
            return new ReportDefinitionDetails(id, updatedTime, createdTime, tenant, access, reportDefinition);
        }

        public static /* synthetic */ ReportDefinitionDetails parse$default(Companion companion, XContentParser xContentParser, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.parse(xContentParser, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

