/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch._types.SlicesCalculation;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class Slices
implements TaggedUnion<Kind, Object>,
PlainJsonSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Slices> _DESERIALIZER = JsonpDeserializer.lazy(Slices::buildSlicesDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private Slices(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private Slices(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Slices of(Function<Builder, ObjectBuilder<Slices>> fn) {
        return fn.apply(new Builder()).build();
    }

    public String _toJsonString() {
        switch (this._kind.ordinal()) {
            case 0: {
                return this.calculation().jsonValue();
            }
            case 1: {
                return String.valueOf(this.count());
            }
        }
        throw new IllegalStateException("Unknown kind " + (Object)((Object)this._kind));
    }

    public boolean isCalculation() {
        return this._kind == Kind.Calculation;
    }

    public SlicesCalculation calculation() {
        return (SlicesCalculation)TaggedUnionUtils.get(this, Kind.Calculation);
    }

    public boolean isCount() {
        return this._kind == Kind.Count;
    }

    public Integer count() {
        return (Integer)TaggedUnionUtils.get(this, Kind.Count);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind.ordinal()) {
                case 1: {
                    generator.write(((Integer)this._value).intValue());
                }
            }
        }
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static JsonpDeserializer<Slices> buildSlicesDeserializer() {
        return new UnionDeserializer.Builder<Slices, Kind, Object>(Slices::new, false).addMember(Kind.Calculation, SlicesCalculation._DESERIALIZER).addMember(Kind.Count, JsonpDeserializer.integerDeserializer()).build();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode((Object)this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Slices other = (Slices)o;
        return Objects.equals((Object)this._kind, (Object)other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Slices> {
        private Kind _kind;
        private Object _value;

        public Builder() {
        }

        private Builder(Slices o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<Slices> calculation(SlicesCalculation v) {
            this._kind = Kind.Calculation;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Slices> count(Integer v) {
            this._kind = Kind.Count;
            this._value = v;
            return this;
        }

        @Override
        public Slices build() {
            this._checkSingleUse();
            return new Slices(this);
        }
    }

    public static enum Kind {
        Calculation,
        Count;

    }
}

