/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.dataframe;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.ml.common.dataframe.ColumnType;
import org.opensearch.ml.common.dataframe.ColumnValue;

public class FloatValue
implements ColumnValue {
    private final float value;

    @Override
    public ColumnType columnType() {
        return ColumnType.FLOAT;
    }

    @Override
    public Object getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public double doubleValue() {
        return Float.valueOf(this.value).doubleValue();
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.columnType());
        out.writeFloat(this.value);
    }

    @Generated
    public FloatValue(float value) {
        this.value = value;
    }

    @Generated
    public String toString() {
        return "FloatValue(value=" + String.valueOf(this.getValue()) + ")";
    }
}

