"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventRoutes = eventRoutes;
var _configSchema = require("@osd/config-schema");
var _common = require("../../common");
var _MDSEnabledClientService = require("../../common/MDSEnabledClientService");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function eventRoutes(router, dataSourceEnabled) {
  let genericParamsAndDataSourceIdQuery = {
    params: _configSchema.schema.any()
  };
  if (dataSourceEnabled) {
    genericParamsAndDataSourceIdQuery = {
      ...genericParamsAndDataSourceIdQuery,
      query: _configSchema.schema.object({
        dataSourceId: _configSchema.schema.string()
      })
    };
  }
  router.get({
    path: `${_common.NODE_API.GET_EVENT}/{eventId}`,
    validate: genericParamsAndDataSourceIdQuery
  }, async (context, request, response) => {
    // @ts-ignore
    const client = _MDSEnabledClientService.MDSEnabledClientService.getClient(request, context, dataSourceEnabled);
    try {
      const resp = await client('notifications.getEventById', {
        eventId: request.params.eventId
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.post({
    path: `${_common.NODE_API.SEND_TEST_MESSAGE}/{configId}`,
    validate: genericParamsAndDataSourceIdQuery
  }, async (context, request, response) => {
    // @ts-ignore
    const client = _MDSEnabledClientService.MDSEnabledClientService.getClient(request, context, dataSourceEnabled);
    try {
      const resp = await client('notifications.sendTestMessage', {
        configId: request.params.configId
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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