"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMustQuery = getMustQuery;
exports.getSearchString = getSearchString;
exports.transformManagedIndexMetaData = transformManagedIndexMetaData;
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function transformManagedIndexMetaData(metaData) {
  if (!metaData) return null;
  // If this is not a managed index or we are still initializing we still return the
  // plugins.index_state_management.policy_id setting, but nothing else from the explain API
  if (!metaData.index) return null;
  return {
    index: metaData.index,
    // We know indexUuid and policyName exist if index exists
    indexUuid: metaData.index_uuid,
    policyId: metaData.policy_id,
    policySeqNo: metaData.policy_seq_no,
    policyPrimaryTerm: metaData.policy_primary_term,
    policyCompleted: metaData.policy_completed,
    rolledOver: metaData.rolled_over,
    transitionTo: metaData.transition_to,
    state: metaData.state ? {
      name: metaData.state.name,
      startTime: metaData.state.start_time
    } : undefined,
    action: metaData.action ? {
      name: metaData.action.name,
      startTime: metaData.action.start_time,
      index: metaData.action.index,
      failed: metaData.action.failed,
      consumedRetries: metaData.action.consumed_retries
    } : undefined,
    retryInfo: metaData.retry_info ? {
      failed: metaData.retry_info.failed,
      consumedRetries: metaData.retry_info.consumed_retries
    } : undefined,
    info: metaData.info
  };
}
function getMustQuery(field, search) {
  const str = search.trim();
  if (search.trim()) {
    return {
      query_string: {
        default_field: field,
        default_operator: "AND",
        query: str ? `*${str.split(" ").join("* *")}*` : "*"
      }
    };
  }
  return {
    match_all: {}
  };
}
function getSearchString(terms, indices, dataStreams, showDataStreams = true) {
  // Terms are searched with a wildcard around them.
  const searchTerms = terms ? `*${_lodash.default.castArray(terms).join("*,*")}*` : "";

  // Indices and data streams are searched with wildcards around them.
  const searchIndices = indices ? `*${_lodash.default.castArray(indices).join("*,*")}*` : "";
  const searchDataStreams = dataStreams ? `*${_lodash.default.castArray(dataStreams).join("*,*")}*` : "";

  // The overall search string is a combination of terms, indices, and data streams.
  // If the search string is blank, then '*' is used to match everything.
  const resolved = [searchTerms, searchIndices, searchDataStreams].filter(value => value !== "").join(",") || "*";
  // We don't want to fetch managed datastream indices if there are not selected by caller.
  return showDataStreams ? resolved : resolved + " -.ds*";
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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