"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _helpers = require("./utils/helpers");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class DestinationsService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "createDestination", async (context, req, res) => {
      try {
        const params = {
          body: req.body
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const createResponse = await client('alerting.createDestination', params);
        return res.ok({
          body: {
            ok: true,
            resp: createResponse
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - createDestination:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "updateDestination", async (context, req, res) => {
      try {
        const {
          destinationId
        } = req.params;
        const {
          ifSeqNo,
          ifPrimaryTerm
        } = req.query;
        const params = {
          body: req.body,
          destinationId,
          ifSeqNo,
          ifPrimaryTerm
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const updateResponse = await client('alerting.updateDestination', params);
        const {
          _version,
          _id
        } = updateResponse;
        return res.ok({
          body: {
            ok: true,
            version: _version,
            id: _id
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - updateDestination:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "deleteDestination", async (context, req, res) => {
      try {
        const {
          destinationId
        } = req.params;
        const params = {
          destinationId
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const response = await client('alerting.deleteDestination', params);
        return res.ok({
          body: {
            ok: response.result === 'deleted'
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - deleteDestination:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getDestination", async (context, req, res) => {
      const {
        destinationId
      } = req.params;
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const params = {
          destinationId
        };
        const resp = await client('alerting.getDestination', params);
        const destination = resp.destinations[0];
        const version = destination.schema_version;
        const ifSeqNo = destination.seq_no;
        const ifPrimaryTerm = destination.primary_term;
        return res.ok({
          body: {
            ok: true,
            destination,
            version,
            ifSeqNo,
            ifPrimaryTerm
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - getDestination:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getDestinations", async (context, req, res) => {
      const client = this.getClientBasedOnDataSource(context, req);
      const {
        from = 0,
        size = 20,
        search = '',
        sortDirection = 'desc',
        sortField = 'start_time',
        type = 'ALL'
      } = req.query;
      var params;
      switch (sortField) {
        case 'name':
          params = {
            sortString: 'destination.name.keyword',
            sortOrder: sortDirection
          };
          break;
        case 'type':
          params = {
            sortString: 'destination.type',
            sortOrder: sortDirection
          };
          break;
        default:
          params = {};
          break;
      }
      params.startIndex = from;
      params.size = size;
      params.searchString = search;
      if (search.trim()) params.searchString = `*${search.trim().split(' ').join('* *')}*`;
      params.destinationType = type;
      try {
        const resp = await client('alerting.searchDestinations', params);
        const destinations = resp.destinations.map(hit => {
          const destination = hit;
          const id = destination.id;
          const version = destination.schema_version;
          const ifSeqNo = destination.seq_no;
          const ifPrimaryTerm = destination.primary_term;
          return {
            id,
            ...destination,
            version,
            ifSeqNo,
            ifPrimaryTerm
          };
        });
        const totalDestinations = resp.totalDestinations;
        return res.ok({
          body: {
            ok: true,
            destinations,
            totalDestinations
          }
        });
      } catch (err) {
        // Indices will be created when the monitor is created.
        if ((0, _helpers.isIndexNotFoundError)(err)) {
          return res.ok({
            body: {
              ok: false,
              totalMonitors: 0,
              monitors: [],
              message: "Config index will be created automatically when the monitor is created"
            }
          });
        } else {
          return res.ok({
            body: {
              ok: false,
              err: err.message
            }
          });
        }
      }
    });
    /**
     *  -----------------------------------------------------
     *  ----------------- Email Account API -----------------
     *  -----------------------------------------------------
     */
    _defineProperty(this, "createEmailAccount", async (context, req, res) => {
      try {
        const params = {
          body: req.body
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const createResponse = await client('alerting.createEmailAccount', params);
        return res.ok({
          body: {
            ok: true,
            resp: createResponse
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - createEmailAccount:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "updateEmailAccount", async (context, req, res) => {
      try {
        const {
          id
        } = req.params;
        const {
          ifSeqNo,
          ifPrimaryTerm
        } = req.query;
        const params = {
          emailAccountId: id,
          ifSeqNo,
          ifPrimaryTerm,
          body: req.body
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const updateResponse = await client('alerting.updateEmailAccount', params);
        const {
          _id
        } = updateResponse;
        return res.ok({
          body: {
            ok: true,
            id: _id
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - updateEmailAccount:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "deleteEmailAccount", async (context, req, res) => {
      try {
        const {
          id
        } = req.params;
        const params = {
          emailAccountId: id
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const deleteResponse = await client('alerting.deleteEmailAccount', params);
        return res.ok({
          body: {
            ok: deleteResponse.result === 'deleted'
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - deleteEmailAccount:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getEmailAccount", async (context, req, res) => {
      try {
        const {
          id
        } = req.params;
        const params = {
          emailAccountId: id
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const getResponse = await client('alerting.getEmailAccount', params);
        const emailAccount = _lodash.default.get(getResponse, 'email_account', null);
        const ifSeqNo = _lodash.default.get(getResponse, '_seq_no', null);
        const ifPrimaryTerm = _lodash.default.get(getResponse, '_primary_term', null);
        if (emailAccount) {
          return res.ok({
            body: {
              ok: true,
              resp: emailAccount,
              ifSeqNo,
              ifPrimaryTerm
            }
          });
        } else {
          return res.ok({
            body: {
              ok: false
            }
          });
        }
      } catch (err) {
        console.error('Alerting - DestinationService - getEmailAccount:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getEmailAccounts", async (context, req, res) => {
      try {
        const {
          from = 0,
          size = 20,
          search = '',
          sortDirection = 'desc',
          sortField = 'name'
        } = req.query;
        let must = {
          match_all: {}
        };
        if (search.trim()) {
          must = {
            query_string: {
              default_field: 'email_account.name',
              default_operator: 'AND',
              query: `*${search.trim().split(' ').join('* *')}*`
            }
          };
        }
        const sortQueryMap = {
          name: {
            'email_account.name.keyword': sortDirection
          }
        };
        let sort = [];
        const sortQuery = sortQueryMap[sortField];
        if (sortQuery) sort = sortQuery;
        const params = {
          body: {
            from,
            size,
            sort,
            query: {
              bool: {
                must
              }
            }
          }
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const getResponse = await client('alerting.getEmailAccounts', params);
        const totalEmailAccounts = _lodash.default.get(getResponse, 'hits.total.value', 0);
        const emailAccounts = _lodash.default.get(getResponse, 'hits.hits', []).map(result => {
          const {
            _id: id,
            _seq_no: ifSeqNo,
            _primary_term: ifPrimaryTerm,
            _source: emailAccount
          } = result;
          return {
            id,
            ...emailAccount,
            ifSeqNo,
            ifPrimaryTerm
          };
        });
        return res.ok({
          body: {
            ok: true,
            emailAccounts,
            totalEmailAccounts
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - getEmailAccounts:', err);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
    /**
     *  -----------------------------------------------------
     *  ----------------- Email Group API -------------------
     *  -----------------------------------------------------
     */
    _defineProperty(this, "createEmailGroup", async (context, req, res) => {
      try {
        const params = {
          body: req.body
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const createResponse = await client('alerting.createEmailGroup', params);
        return res.ok({
          body: {
            ok: true,
            resp: createResponse
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - createEmailGroup:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "updateEmailGroup", async (context, req, res) => {
      try {
        const {
          id
        } = req.params;
        const {
          ifSeqNo,
          ifPrimaryTerm
        } = req.query;
        const params = {
          emailGroupId: id,
          ifSeqNo,
          ifPrimaryTerm,
          body: req.body
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const updateResponse = await client('alerting.updateEmailGroup', params);
        const {
          _id
        } = updateResponse;
        return res.ok({
          body: {
            ok: true,
            id: _id
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - updateEmailGroup:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "deleteEmailGroup", async (context, req, res) => {
      try {
        const {
          id
        } = req.params;
        const params = {
          emailGroupId: id
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const deleteResponse = await client('alerting.deleteEmailGroup', params);
        return res.ok({
          body: {
            ok: deleteResponse.result === 'deleted'
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - deleteEmailGroup:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getEmailGroup", async (context, req, res) => {
      try {
        const {
          id
        } = req.params;
        const params = {
          emailGroupId: id
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const getResponse = await client('alerting.getEmailGroup', params);
        const emailGroup = _lodash.default.get(getResponse, 'email_group', null);
        const ifSeqNo = _lodash.default.get(getResponse, '_seq_no', null);
        const ifPrimaryTerm = _lodash.default.get(getResponse, '_primary_term', null);
        if (emailGroup) {
          return res.ok({
            body: {
              ok: true,
              resp: emailGroup,
              ifSeqNo,
              ifPrimaryTerm
            }
          });
        } else {
          return res.ok({
            body: {
              ok: false
            }
          });
        }
      } catch (err) {
        console.error('Alerting - DestinationService - getEmailGroup:', err);
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    _defineProperty(this, "getEmailGroups", async (context, req, res) => {
      try {
        const {
          from = 0,
          size = 20,
          search = '',
          sortDirection = 'desc',
          sortField = 'name'
        } = req.query;
        let must = {
          match_all: {}
        };
        if (search.trim()) {
          must = {
            query_string: {
              default_field: 'email_group.name',
              default_operator: 'AND',
              query: `*${search.trim().split(' ').join('* *')}*`
            }
          };
        }
        const sortQueryMap = {
          name: {
            'email_group.name.keyword': sortDirection
          }
        };
        let sort = [];
        const sortQuery = sortQueryMap[sortField];
        if (sortQuery) sort = sortQuery;
        const params = {
          body: {
            from,
            size,
            sort,
            query: {
              bool: {
                must
              }
            }
          }
        };
        const client = this.getClientBasedOnDataSource(context, req);
        const getResponse = await client('alerting.getEmailGroups', params);
        const totalEmailGroups = _lodash.default.get(getResponse, 'hits.total.value', 0);
        const emailGroups = _lodash.default.get(getResponse, 'hits.hits', []).map(result => {
          const {
            _id: id,
            _seq_no: ifSeqNo,
            _primary_term: ifPrimaryTerm,
            _source: emailGroup
          } = result;
          return {
            id,
            ...emailGroup,
            ifSeqNo,
            ifPrimaryTerm
          };
        });
        return res.ok({
          body: {
            ok: true,
            emailGroups,
            totalEmailGroups
          }
        });
      } catch (err) {
        console.error('Alerting - DestinationService - getEmailGroups:', err);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
  }
}
exports.default = DestinationsService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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