/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.serde;

import java.util.List;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBiVisitor;
import org.apache.calcite.rex.RexBiVisitorImpl;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLambda;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexNodeAndFieldIndex;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.data.type.OpenSearchTextType;
import org.opensearch.sql.opensearch.storage.script.CalciteScriptEngine;
import org.opensearch.sql.opensearch.storage.serde.ScriptParameterHelper;
import shaded.com.google.common.collect.ImmutableList;

public class RexStandardizer
extends RexBiVisitorImpl<RexNode, ScriptParameterHelper> {
    private static final RexStandardizer standardizer = new RexStandardizer(true);

    protected RexStandardizer(boolean deep) {
        super(deep);
    }

    public RexNode visitCall(RexCall call, ScriptParameterHelper helper) {
        boolean[] update = new boolean[]{false};
        List<RexNode> clonedOperands = this.visitList((List<? extends RexNode>)call.operands, helper, update);
        if (update[0]) {
            return call.clone(call.getType(), clonedOperands);
        }
        return call;
    }

    public RexNode visitInputRef(RexInputRef inputRef, ScriptParameterHelper helper) {
        int index = inputRef.getIndex();
        RelDataTypeField field = helper.inputFieldList.get(index);
        ExprType exprType = helper.fieldTypes.get(field.getName());
        String docFieldName = exprType == ExprCoreType.STRUCT || exprType == ExprCoreType.ARRAY ? null : OpenSearchTextType.toKeywordSubField(field.getName(), exprType);
        int newIndex = helper.sources.size();
        if (docFieldName != null) {
            helper.digests.add(docFieldName);
            helper.sources.add(CalciteScriptEngine.Source.DOC_VALUE.getValue());
        } else {
            helper.digests.add(field.getName());
            helper.sources.add(CalciteScriptEngine.Source.SOURCE.getValue());
        }
        return new RexDynamicParam(field.getType(), newIndex);
    }

    public RexNode visitLiteral(RexLiteral literal, ScriptParameterHelper helper) {
        if (literal.getTypeName() == SqlTypeName.SARG || literal.getType().getSqlTypeName() == SqlTypeName.DECIMAL || literal.getTypeName() == SqlTypeName.SYMBOL || literal.getTypeName() == SqlTypeName.NULL || SqlTypeName.INTERVAL_TYPES.contains(literal.getTypeName())) {
            return literal;
        }
        Object literalValue = RexStandardizer.translateLiteral(literal);
        if (literalValue == null) {
            return literal;
        }
        int newIndex = helper.sources.size();
        helper.sources.add(CalciteScriptEngine.Source.LITERAL.getValue());
        helper.digests.add(literalValue);
        return new RexDynamicParam(literal.getType(), newIndex);
    }

    public RexNode visitLocalRef(RexLocalRef localRef, ScriptParameterHelper arg) {
        return localRef;
    }

    public RexNode visitOver(RexOver over, ScriptParameterHelper arg) {
        return over;
    }

    public RexNode visitCorrelVariable(RexCorrelVariable correlVariable, ScriptParameterHelper arg) {
        return correlVariable;
    }

    public RexNode visitDynamicParam(RexDynamicParam dynamicParam, ScriptParameterHelper arg) {
        return dynamicParam;
    }

    public RexNode visitRangeRef(RexRangeRef rangeRef, ScriptParameterHelper arg) {
        return rangeRef;
    }

    public RexNode visitFieldAccess(RexFieldAccess fieldAccess, ScriptParameterHelper arg) {
        return fieldAccess;
    }

    public RexNode visitSubQuery(RexSubQuery subQuery, ScriptParameterHelper arg) {
        return subQuery;
    }

    public RexNode visitTableInputRef(RexTableInputRef ref, ScriptParameterHelper arg) {
        return ref;
    }

    public RexNode visitPatternFieldRef(RexPatternFieldRef fieldRef, ScriptParameterHelper arg) {
        return fieldRef;
    }

    public RexNode visitLambda(RexLambda lambda, ScriptParameterHelper arg) {
        return lambda;
    }

    public RexNode visitNodeAndFieldIndex(RexNodeAndFieldIndex nodeAndFieldIndex, ScriptParameterHelper arg) {
        return nodeAndFieldIndex;
    }

    protected List<RexNode> visitList(List<? extends RexNode> exprs, ScriptParameterHelper helper, boolean[] update) {
        ImmutableList.Builder clonedOperands = ImmutableList.builder();
        for (RexNode rexNode : exprs) {
            RexNode clonedOperand = (RexNode)rexNode.accept((RexBiVisitor)this, (Object)helper);
            if (clonedOperand != rexNode && update != null) {
                update[0] = true;
            }
            clonedOperands.add((Object)clonedOperand);
        }
        return clonedOperands.build();
    }

    private static Object translateLiteral(RexLiteral literal) {
        Expression expression = RexToLixTranslator.translateLiteral((RexLiteral)literal, (RelDataType)literal.getType(), (JavaTypeFactory)OpenSearchTypeFactory.TYPE_FACTORY, (RexImpTable.NullAs)RexImpTable.NullAs.NOT_POSSIBLE);
        if (expression instanceof ConstantExpression) {
            ConstantExpression constantExpression = (ConstantExpression)expression;
            return constantExpression.value;
        }
        return null;
    }

    public static RexNode standardizeRexNodeExpression(RexNode rexNode, ScriptParameterHelper helper) {
        return (RexNode)rexNode.accept((RexBiVisitor)standardizer, (Object)helper);
    }
}

