/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query.functionscore;

import java.util.Map;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.index.query.functionscore.GaussDecayFunctionBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilder;
import org.opensearch.protobufs.DateDecayPlacement;
import org.opensearch.protobufs.DecayFunction;
import org.opensearch.protobufs.DecayPlacement;
import org.opensearch.protobufs.GeoDecayPlacement;
import org.opensearch.protobufs.NumericDecayPlacement;
import org.opensearch.transport.grpc.proto.request.common.GeoPointProtoUtils;

class GaussDecayFunctionProtoUtils {
    private GaussDecayFunctionProtoUtils() {
    }

    static ScoreFunctionBuilder<?> fromProto(DecayFunction decayFunction) {
        if (decayFunction == null || decayFunction.getPlacementCount() == 0) {
            throw new IllegalArgumentException("DecayFunction must have at least one placement");
        }
        Map.Entry entry = decayFunction.getPlacementMap().entrySet().iterator().next();
        String fieldName = (String)entry.getKey();
        DecayPlacement decayPlacement = (DecayPlacement)entry.getValue();
        if (decayPlacement.hasNumericDecayPlacement()) {
            return GaussDecayFunctionProtoUtils.parseNumericGaussDecay(fieldName, decayPlacement.getNumericDecayPlacement());
        }
        if (decayPlacement.hasGeoDecayPlacement()) {
            return GaussDecayFunctionProtoUtils.parseGeoGaussDecay(fieldName, decayPlacement.getGeoDecayPlacement());
        }
        if (decayPlacement.hasDateDecayPlacement()) {
            return GaussDecayFunctionProtoUtils.parseDateGaussDecay(fieldName, decayPlacement.getDateDecayPlacement());
        }
        throw new IllegalArgumentException("Unsupported decay placement type");
    }

    private static ScoreFunctionBuilder<?> parseNumericGaussDecay(String fieldName, NumericDecayPlacement numericPlacement) {
        GaussDecayFunctionBuilder builder = numericPlacement.hasDecay() ? new GaussDecayFunctionBuilder(fieldName, (Object)numericPlacement.getOrigin(), (Object)numericPlacement.getScale(), (Object)(numericPlacement.hasOffset() ? Double.valueOf(numericPlacement.getOffset()) : null), numericPlacement.getDecay()) : new GaussDecayFunctionBuilder(fieldName, (Object)numericPlacement.getOrigin(), (Object)numericPlacement.getScale(), numericPlacement.hasOffset() ? Double.valueOf(numericPlacement.getOffset()) : null);
        return builder;
    }

    private static ScoreFunctionBuilder<?> parseGeoGaussDecay(String fieldName, GeoDecayPlacement geoPlacement) {
        GeoPoint geoPoint = GeoPointProtoUtils.parseGeoPoint(geoPlacement.getOrigin());
        GaussDecayFunctionBuilder builder = geoPlacement.hasDecay() ? new GaussDecayFunctionBuilder(fieldName, (Object)geoPoint, (Object)geoPlacement.getScale(), (Object)(geoPlacement.hasOffset() ? geoPlacement.getOffset() : null), geoPlacement.getDecay()) : new GaussDecayFunctionBuilder(fieldName, (Object)geoPoint, (Object)geoPlacement.getScale(), (Object)(geoPlacement.hasOffset() ? geoPlacement.getOffset() : null));
        return builder;
    }

    private static ScoreFunctionBuilder<?> parseDateGaussDecay(String fieldName, DateDecayPlacement datePlacement) {
        String origin;
        String string = origin = datePlacement.hasOrigin() ? datePlacement.getOrigin() : null;
        GaussDecayFunctionBuilder builder = datePlacement.hasDecay() ? new GaussDecayFunctionBuilder(fieldName, (Object)origin, (Object)datePlacement.getScale(), (Object)(datePlacement.hasOffset() ? datePlacement.getOffset() : null), datePlacement.getDecay()) : new GaussDecayFunctionBuilder(fieldName, (Object)origin, (Object)datePlacement.getScale(), (Object)(datePlacement.hasOffset() ? datePlacement.getOffset() : null));
        return builder;
    }
}

