/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.core;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1Null;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.util.StreamableOutputException;
import oracle.security.pki.util.Utils;

public class AlgorithmIdentifier
implements Externalizable,
Cloneable,
ASN1Object {
    private ASN1ObjectID a;
    private ASN1Object b;
    private ASN1Sequence c;

    public AlgorithmIdentifier(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this.a = aSN1ObjectID;
        this.b = aSN1Object;
    }

    public AlgorithmIdentifier(ASN1ObjectID aSN1ObjectID, boolean bl) {
        this.a = aSN1ObjectID;
        this.b = bl ? new ASN1Null() : null;
    }

    public AlgorithmIdentifier(ASN1ObjectID aSN1ObjectID) {
        this(aSN1ObjectID, true);
    }

    public AlgorithmIdentifier(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public AlgorithmIdentifier(ASN1Sequence aSN1Sequence) throws ASN1FormatException {
        this.a(aSN1Sequence);
    }

    public AlgorithmIdentifier() {
    }

    public ASN1ObjectID a() {
        return this.a;
    }

    public ASN1Object b() {
        return this.b;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AlgorithmIdentifier)) {
            return false;
        }
        AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)object;
        if (!this.a.equals(algorithmIdentifier.a())) {
            return false;
        }
        if (this.b == null || this.b instanceof ASN1Null) {
            return algorithmIdentifier.b() == null || algorithmIdentifier.b() instanceof ASN1Null;
        }
        if (algorithmIdentifier.b == null || algorithmIdentifier.b instanceof ASN1Null) {
            return false;
        }
        return Utils.areEqual(Utils.toBytes(this.b), Utils.toBytes(algorithmIdentifier.b()));
    }

    public int hashCode() {
        return this.a.hashCode() + (this.b == null || this.b instanceof ASN1Null ? 0 : Utils.hashBytes(this.b));
    }

    public String toString() {
        return "{ oid = " + this.a.d() + ", parameters = " + this.b + " }";
    }

    public Object clone() {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier();
        if (this.a != null) {
            int[] nArray = (int[])this.a.b().clone();
            algorithmIdentifier.a = new ASN1ObjectID(nArray);
        }
        try {
            if (this.b != null) {
                algorithmIdentifier.b = ASN1Utils.a(Utils.toStream(this.b));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier parameters to stream: " + iOException.toString());
        }
        try {
            if (this.c != null) {
                algorithmIdentifier.c = new ASN1Sequence(Utils.toStream(this.c));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier contents to stream: " + iOException.toString());
        }
        return algorithmIdentifier;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        this.a(aSN1Sequence);
    }

    private void a(ASN1Sequence aSN1Sequence) throws ASN1FormatException {
        try {
            this.a = (ASN1ObjectID)aSN1Sequence.a(0);
            this.b = aSN1Sequence.c() == 1 ? null : aSN1Sequence.a(1);
            this.c = null;
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ASN1FormatException(arrayIndexOutOfBoundsException.toString());
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.c().output(outputStream);
    }

    @Override
    public int length() {
        return this.c().length();
    }

    private ASN1Sequence c() {
        if (this.c == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.a(this.a);
            if (this.b != null) {
                aSN1Sequence.a(this.b);
            }
            this.c = aSN1Sequence;
        }
        return this.c;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }
}

