/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

/*
 * This file is part of LibreOffice published API.
 */
#ifndef INCLUDED_CPPU_MACROS_HXX
#define INCLUDED_CPPU_MACROS_HXX

#include "sal/types.h"

/** Namespace name for compiler/ platform, e.g. gcc3, msci

    @deprecated implementation detail, not to be used by client code
*/
#define CPPU_CURRENT_NAMESPACE CPPU_ENV

/// @cond INTERNAL

/** Patching the GCC 3 incompatible alignment change for Linux.

    This macro is appended by cppumaker to every first member of a struct, if
    the struct inherits from a base struct and the first member is neither
    double nor sal_[u]Int64.  (The double/sal_[u]Int64 restriction is due to a
    bug in GCC prior to version 3.3, which would cause __alignof__ of such a
    struct to become 8 instead of 4 if CPPU_GCC3_ALIGN were added to its first
    member.)
*/
#if defined(__GNUC__)
#define CPPU_GCC3_ALIGN( base_struct ) __attribute__ ((aligned (__alignof__ (base_struct))))
#else
#define CPPU_GCC3_ALIGN( base_struct )
#endif

/**
   Exporting the symbols necessary for exception handling on GCC.

   These macros are used in the headers generated by cppumaker for UNO exception
   types, to ensure that exception handling does not fail on GCC.
*/
#define CPPU_GCC_DLLPUBLIC_EXPORT SAL_EXCEPTION_DLLPUBLIC_EXPORT
#define CPPU_GCC_DLLPRIVATE SAL_EXCEPTION_DLLPRIVATE

/// @endcond

#endif // INCLUDED_CPPU_MACROS_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
