/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.jaxrs;

import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.util.stream.Stream;
import org.keycloak.quarkus.runtime.transaction.TransactionalSessionHandler;
import org.keycloak.utils.KeycloakSessionUtil;

@Provider
@PreMatching
@Priority(value=1)
public class CloseSessionFilter
implements ContainerResponseFilter,
TransactionalSessionHandler {
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        final Object entity = responseContext.getEntity();
        if (entity instanceof Stream) {
            Stream entityStream = (Stream)entity;
            entityStream.onClose(this::closeSession);
            return;
        }
        if (entity instanceof StreamingOutput) {
            responseContext.setEntity((Object)new StreamingOutput(){

                public void write(OutputStream output) throws IOException, WebApplicationException {
                    try {
                        ((StreamingOutput)entity).write(output);
                    }
                    finally {
                        CloseSessionFilter.this.closeSession();
                    }
                }
            });
            return;
        }
        this.closeSession();
    }

    private void closeSession() {
        this.close(KeycloakSessionUtil.getKeycloakSession());
    }
}

