/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.reference;

import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ignore.cache.IgnorePatternsMatchedFilesCache;
import com.intellij.openapi.vcs.changes.ignore.cache.PatternCache;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreLanguage;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntry;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreFile;
import com.intellij.openapi.vcs.changes.ignore.util.RegexUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoreReferenceSet
extends FileReferenceSet {
    @NotNull
    private final IgnorePatternsMatchedFilesCache myIgnorePatternsMatchedFilesCache;
    private final PatternCache myPatternCache;

    public IgnoreReferenceSet(@NotNull IgnoreEntry element) {
        if (element == null) {
            IgnoreReferenceSet.$$$reportNull$$$0(0);
        }
        super((PsiElement)element);
        this.myIgnorePatternsMatchedFilesCache = IgnorePatternsMatchedFilesCache.getInstance(element.getProject());
        this.myPatternCache = PatternCache.getInstance(element.getProject());
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new IgnoreReference(this, range, index, text);
    }

    public boolean isEndingSlashNotAllowed() {
        return false;
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        VirtualFile affectedRoot;
        Language language;
        PsiDirectory containingDirectory;
        PsiFile containingFile = this.getElement().getContainingFile();
        PsiDirectory psiDirectory = containingDirectory = containingFile.getParent() != null ? containingFile.getParent() : containingFile.getOriginalFile().getContainingDirectory();
        if (containingDirectory == null && (language = containingFile.getLanguage()) instanceof IgnoreLanguage && (affectedRoot = ((IgnoreLanguage)language).getAffectedRoot(containingFile.getProject(), containingFile.getOriginalFile().getVirtualFile())) != null) {
            containingDirectory = containingFile.getManager().findDirectory(affectedRoot);
        }
        Collection<Object> collection = containingDirectory != null ? Collections.singletonList(containingDirectory) : super.computeDefaultContexts();
        if (collection == null) {
            IgnoreReferenceSet.$$$reportNull$$$0(1);
        }
        return collection;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return item -> {
            Project project = item.getProject();
            PsiFile originalFile = this.getElement().getContainingFile().getOriginalFile();
            VirtualFile ignoreFile = originalFile.getVirtualFile();
            Language language = originalFile.getLanguage();
            if (!(language instanceof IgnoreLanguage)) {
                return false;
            }
            VirtualFile ignoreFileAffectedRoot = ((IgnoreLanguage)language).getAffectedRoot(project, ignoreFile);
            VirtualFile ignoreFileVcsRoot = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)ignoreFileAffectedRoot);
            if (ignoreFileVcsRoot == null) {
                return false;
            }
            return IgnoreReferenceSet.isFileUnderSameVcsRoot(project, ignoreFileVcsRoot, item.getVirtualFile());
        };
    }

    @Nullable
    public FileReference getLastReference() {
        FileReference lastReference = super.getLastReference();
        if (lastReference != null && lastReference.getCanonicalText().endsWith(this.getSeparatorString())) {
            return this.myReferences != null && this.myReferences.length > 1 ? this.myReferences[this.myReferences.length - 2] : null;
        }
        return lastReference;
    }

    public boolean couldBeConvertedTo(boolean relative) {
        return false;
    }

    protected void reparse() {
        int nextSlash;
        ProgressManager.checkCanceled();
        String str = StringUtil.trimEnd((String)this.getPathString(), (String)this.getSeparatorString());
        ArrayList<FileReference> referencesList = new ArrayList<FileReference>();
        String separatorString = this.getSeparatorString();
        int sepLen = separatorString.length();
        int currentSlash = -sepLen;
        int startInElement = this.getStartInElement();
        while (currentSlash + sepLen < str.length() && Character.isWhitespace(str.charAt(currentSlash + sepLen))) {
            ++currentSlash;
        }
        if (currentSlash + sepLen + sepLen < str.length() && str.substring(currentSlash + sepLen, currentSlash + sepLen + sepLen).equals(separatorString)) {
            currentSlash += sepLen;
        }
        int index = 0;
        if (str.equals(separatorString)) {
            FileReference fileReference = this.createFileReference(new TextRange(startInElement, startInElement + sepLen), index++, separatorString);
            referencesList.add(fileReference);
        }
        do {
            ProgressManager.checkCanceled();
            nextSlash = str.indexOf(separatorString, currentSlash + sepLen);
            String subReferenceText = nextSlash > 0 ? str.substring(0, nextSlash) : str;
            TextRange range = new TextRange(startInElement + currentSlash + sepLen, startInElement + (nextSlash > 0 ? nextSlash : str.length()));
            FileReference ref = this.createFileReference(range, index++, subReferenceText);
            referencesList.add(ref);
        } while ((currentSlash = nextSlash) >= 0);
        this.myReferences = referencesList.toArray(FileReference.EMPTY);
    }

    protected String getNewAbsolutePath(@NotNull PsiFileSystemItem root, @NotNull String relativePath) {
        String relativeToIgnoreFileParent;
        VirtualFile relativeFile;
        if (root == null) {
            IgnoreReferenceSet.$$$reportNull$$$0(2);
        }
        if (relativePath == null) {
            IgnoreReferenceSet.$$$reportNull$$$0(3);
        }
        PsiFile ignoreFile = this.getContainingFile();
        VirtualFile rootVF = root.getVirtualFile();
        if (rootVF != null && ignoreFile != null && ignoreFile.getVirtualFile() != null && ignoreFile.getVirtualFile().getParent() != null && !rootVF.equals(ignoreFile.getVirtualFile().getParent()) && (relativeFile = rootVF.findFileByRelativePath(relativePath)) != null && (relativeToIgnoreFileParent = VfsUtilCore.getRelativePath((VirtualFile)relativeFile, (VirtualFile)ignoreFile.getVirtualFile().getParent())) != null) {
            return this.absoluteUrlNeedsStartSlash() ? "/" + relativeToIgnoreFileParent : relativeToIgnoreFileParent;
        }
        return super.getNewAbsolutePath(root, relativePath);
    }

    private static boolean isFileUnderSameVcsRoot(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull VirtualFile file) {
        VirtualFile fileVcsRoot;
        if (project == null) {
            IgnoreReferenceSet.$$$reportNull$$$0(4);
        }
        if (vcsRoot == null) {
            IgnoreReferenceSet.$$$reportNull$$$0(5);
        }
        if (file == null) {
            IgnoreReferenceSet.$$$reportNull$$$0(6);
        }
        return (fileVcsRoot = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)file)) != null && vcsRoot.equals(fileVcsRoot);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ignore/reference/IgnoreReferenceSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ignore/reference/IgnoreReferenceSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNewAbsolutePath";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFileUnderSameVcsRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private final class IgnoreReference
    extends FileReference {
        private IgnoreReference(FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
            if (fileReferenceSet == null) {
                IgnoreReference.$$$reportNull$$$0(0);
            }
            super(fileReferenceSet, range, index, text);
        }

        protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, @NotNull Collection<? super ResolveResult> result2, boolean caseSensitive) {
            if (text == null) {
                IgnoreReference.$$$reportNull$$$0(1);
            }
            if (context == null) {
                IgnoreReference.$$$reportNull$$$0(2);
            }
            if (result2 == null) {
                IgnoreReference.$$$reportNull$$$0(3);
            }
            ProgressManager.checkCanceled();
            super.innerResolveInContext(text, context, result2, caseSensitive);
            PsiFile containingFile = IgnoreReferenceSet.this.getContainingFile();
            if (!(containingFile instanceof IgnoreFile)) {
                return;
            }
            VirtualFile ignoreFileAffectedRoot = ((IgnoreLanguage)containingFile.getLanguage()).getAffectedRoot(context.getProject(), containingFile.getVirtualFile());
            if (ignoreFileAffectedRoot == null) {
                return;
            }
            VirtualFile ignoreFileVcsRoot = VcsUtil.getVcsRootFor((Project)context.getProject(), (VirtualFile)ignoreFileAffectedRoot);
            if (ignoreFileVcsRoot == null) {
                return;
            }
            VirtualFile contextVirtualFile = context.getVirtualFile();
            if (contextVirtualFile != null) {
                IgnoreEntry entry = (IgnoreEntry)this.getFileReferenceSet().getElement();
                String current = this.getCanonicalText();
                Pattern pattern = IgnoreReferenceSet.this.myPatternCache.createPattern(current, entry.getSyntax());
                if (pattern != null) {
                    PsiDirectory parent = this.getElement().getContainingFile().getParent();
                    VirtualFile root = parent != null ? parent.getVirtualFile() : null;
                    PsiManager psiManager = this.getElement().getManager();
                    ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(IgnoreReferenceSet.this.myIgnorePatternsMatchedFilesCache.getFilesForPattern(pattern));
                    if (files.isEmpty()) {
                        files.addAll(ContainerUtil.filter((Object[])context.getVirtualFile().getChildren(), virtualFile -> IgnoreReferenceSet.isFileUnderSameVcsRoot(context.getProject(), ignoreFileVcsRoot, virtualFile)));
                    }
                    for (VirtualFile file : files) {
                        PsiFileSystemItem psiFileSystemItem;
                        ProgressManager.checkCanceled();
                        if (!IgnoreReferenceSet.isFileUnderSameVcsRoot(context.getProject(), ignoreFileVcsRoot, file)) continue;
                        String relativeToIgnoreFileVcsRoot = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)ignoreFileVcsRoot);
                        String name = root != null ? VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root) : (relativeToIgnoreFileVcsRoot != null ? relativeToIgnoreFileVcsRoot : file.getName());
                        if (!RegexUtil.match(pattern, name) || (psiFileSystemItem = IgnoreReference.getPsiFileSystemItem(psiManager, file)) == null) continue;
                        result2.add((ResolveResult)new PsiElementResolveResult((PsiElement)psiFileSystemItem));
                    }
                }
            }
        }

        @Nullable
        private static PsiFileSystemItem getPsiFileSystemItem(@NotNull PsiManager manager, @NotNull VirtualFile file) {
            if (manager == null) {
                IgnoreReference.$$$reportNull$$$0(4);
            }
            if (file == null) {
                IgnoreReference.$$$reportNull$$$0(5);
            }
            if (!file.isValid()) {
                return null;
            }
            return file.isDirectory() ? manager.findDirectory(file) : manager.findFile(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileReferenceSet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ignore/reference/IgnoreReferenceSet$IgnoreReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "innerResolveInContext";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPsiFileSystemItem";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

