/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity.examples;

import info.debatty.java.stringsimilarity.Cosine;
import info.debatty.java.stringsimilarity.Damerau;
import info.debatty.java.stringsimilarity.Jaccard;
import info.debatty.java.stringsimilarity.JaroWinkler;
import info.debatty.java.stringsimilarity.Levenshtein;
import info.debatty.java.stringsimilarity.NGram;
import info.debatty.java.stringsimilarity.SorensenDice;
import info.debatty.java.stringsimilarity.interfaces.StringDistance;
import java.util.LinkedList;

public class nischay21 {
    public static void main(String[] args) {
        String s1 = "MINI GRINDER KIT";
        String s2 = "Weiler 13001 Mini Grinder Accessory Kit, For Use With Small Right Angle Grinders";
        String s3 = "Milwaukee Video Borescope, Rotating Inspection Scope, Series: M-SPECTOR 360, 2.7 in 640 x 480 pixels High-Resolution LCD, Plastic, Black/Red";
        LinkedList<StringDistance> algos = new LinkedList<StringDistance>();
        algos.add(new JaroWinkler());
        algos.add(new Levenshtein());
        algos.add(new NGram());
        algos.add(new Damerau());
        algos.add(new Jaccard());
        algos.add(new SorensenDice());
        algos.add(new Cosine());
        System.out.println("S1 vs S2");
        for (StringDistance algo : algos) {
            System.out.print(algo.getClass().getSimpleName() + " : ");
            System.out.println(algo.distance(s1, s2));
        }
        System.out.println();
        System.out.println("S1 vs S3");
        for (StringDistance algo : algos) {
            System.out.print(algo.getClass().getSimpleName() + " : ");
            System.out.println(algo.distance(s1, s3));
        }
        System.out.println();
        System.out.println("With .toLower()");
        System.out.println("S1 vs S2");
        for (StringDistance algo : algos) {
            System.out.print(algo.getClass().getSimpleName() + " : ");
            System.out.println(algo.distance(s1.toLowerCase(), s2.toLowerCase()));
        }
        System.out.println();
        System.out.println("S1 vs S3");
        for (StringDistance algo : algos) {
            System.out.print(algo.getClass().getSimpleName() + " : ");
            System.out.println(algo.distance(s1.toLowerCase(), s3.toLowerCase()));
        }
        System.out.println();
    }
}

