/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.inline;

import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrRichPropertyReference;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u000b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/inline/SyntheticAccessorCollector;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "<init>", "()V", "accessorSymbols", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lkotlin/collections/HashSet;", "getAccessorSymbols", "()Ljava/util/HashSet;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitMemberAccess", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "visitRichFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRichFunctionReference;", "visitRichPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRichPropertyReference;", "visitFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitProbablyAccessorSymbol", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "ir.inline"})
final class SyntheticAccessorCollector
extends IrVisitorVoid {
    @NotNull
    private final HashSet<IrFunctionSymbol> accessorSymbols = new HashSet();

    @NotNull
    public final HashSet<IrFunctionSymbol> getAccessorSymbols() {
        return this.accessorSymbols;
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IrVisitorsKt.acceptChildrenVoid(element, this);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        this.visitProbablyAccessorSymbol((IrSymbol)expression.getSymbol());
        super.visitMemberAccess(expression);
    }

    @Override
    public void visitRichFunctionReference(@NotNull IrRichFunctionReference expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.visitProbablyAccessorSymbol(expression.getOverriddenFunctionSymbol());
        super.visitRichFunctionReference(expression);
    }

    @Override
    public void visitRichPropertyReference(@NotNull IrRichPropertyReference expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.visitProbablyAccessorSymbol(expression.getGetterFunction().getSymbol());
        IrSimpleFunction irSimpleFunction = expression.getSetterFunction();
        this.visitProbablyAccessorSymbol(irSimpleFunction != null ? irSimpleFunction.getSymbol() : null);
        super.visitRichPropertyReference(expression);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.visitProbablyAccessorSymbol(declaration.getSymbol());
        super.visitFunction(declaration);
    }

    private final void visitProbablyAccessorSymbol(IrSymbol symbol) {
        if (symbol instanceof IrFunctionSymbol && Intrinsics.areEqual((Object)((IrFunctionSymbol)symbol).getOwner().getOrigin(), (Object)IrDeclarationOrigin.Companion.getSYNTHETIC_ACCESSOR())) {
            ((Collection)this.accessorSymbols).add(symbol);
        }
    }
}

