/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.ir;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H&R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineReferenceLocator;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitor;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "data", "visitFunctionAccess", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitInlineLambda", "argument", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "callee", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "scope", "backend.jvm"})
public abstract class IrInlineReferenceLocator
extends IrVisitor<Unit, IrDeclaration> {
    @NotNull
    private final JvmBackendContext context;

    public IrInlineReferenceLocator(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public void visitElement(@NotNull IrElement element, @Nullable IrDeclaration data) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.acceptChildren((IrVisitor)this, (Object)(element instanceof IrDeclaration && !(element instanceof IrVariable) ? (IrDeclaration)element : data));
    }

    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable IrDeclaration data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrFunction function2 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        if (JvmIrInlineUtilsKt.isInlineFunctionCall(function2, this.context)) {
            for (IrValueParameter parameter : function2.getParameters()) {
                IrExpression irExpression = (IrExpression)expression2.getArguments().get(parameter.getIndexInParameters());
                if (irExpression == null || (irExpression = JvmIrInlineUtilsKt.unwrapInlineLambda((IrStatement)irExpression)) == null) continue;
                IrExpression lambda = irExpression;
                IrDeclaration irDeclaration = data;
                Intrinsics.checkNotNull((Object)irDeclaration);
                this.visitInlineLambda((IrFunctionReference)lambda, function2, parameter, irDeclaration);
            }
        }
        super.visitFunctionAccess(expression2, (Object)data);
    }

    public abstract void visitInlineLambda(@NotNull IrFunctionReference var1, @NotNull IrFunction var2, @NotNull IrValueParameter var3, @NotNull IrDeclaration var4);
}

