# frozen_string_literal: true

class FinalizeFixVulnerabilityReadsHasIssues < Gitlab::Database::Migration[2.2]
  disable_ddl_transaction!
  restrict_gitlab_migration gitlab_schema: :gitlab_main
  milestone '17.5'

  def up
    ensure_batched_background_migration_is_finished(
      job_class_name: 'FixVulnerabilityReadsHasIssues',
      table_name: :vulnerability_issue_links,
      column_name: :vulnerability_id,
      job_arguments: [],
      finalize: true
    )
  end

  def down
    # no op
  end
end
