/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.OptionDialog;
import generic.theme.GIcon;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchContext;
import ghidra.feature.vt.gui.task.ClearMatchTagTask;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public class RemoveMatchTagAction
extends DockingAction {
    private static final String MENU_GROUP = "A_VT_Edit_2";
    private static final Icon EDIT_TAG_ICON = new GIcon("icon.version.tracking.action.match.tag.remove");
    private static final String ACTION_NAME = "Remove VTMatch Tags";
    private int tagCount = 0;

    public RemoveMatchTagAction() {
        super(ACTION_NAME, VTPlugin.OWNER);
        this.setDescription("Remove Match Tag");
        this.setToolBarData(new ToolBarData(EDIT_TAG_ICON, MENU_GROUP));
        MenuData menuData = new MenuData(new String[]{"Remove Tag"}, EDIT_TAG_ICON, MENU_GROUP);
        menuData.setMenuSubGroup("2");
        this.setPopupMenuData(menuData);
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Remove_Tag"));
    }

    public void actionPerformed(ActionContext context) {
        this.removeTag(context);
    }

    public boolean isEnabledForContext(ActionContext context) {
        this.tagCount = 0;
        if (!(context instanceof VTMatchContext)) {
            return false;
        }
        VTMatchContext matchContext = (VTMatchContext)context;
        List<VTMatch> matches = matchContext.getSelectedMatches();
        if (matches.size() == 0) {
            return false;
        }
        this.tagCount = this.calculateTagCount(matches);
        return this.tagCount > 0;
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!(context instanceof VTMatchContext)) {
            return false;
        }
        VTMatchContext matchContext = (VTMatchContext)context;
        List<VTMatch> matches = matchContext.getSelectedMatches();
        return matches.size() != 0;
    }

    private int calculateTagCount(List<VTMatch> matches) {
        int count = 0;
        for (VTMatch match : matches) {
            VTMatchTag tag = match.getTag();
            if (tag == null || tag == VTMatchTag.UNTAGGED) continue;
            ++count;
        }
        return count;
    }

    private void removeTag(ActionContext context) {
        int choice;
        VTMatchContext matchContext = (VTMatchContext)context;
        ComponentProvider componentProvider = matchContext.getComponentProvider();
        JComponent component = componentProvider.getComponent();
        Object message = "1 tag?";
        if (this.tagCount > 1) {
            message = this.tagCount + " tags?";
        }
        if ((choice = OptionDialog.showYesNoDialog((Component)component, (String)"Remove Match Tag?", (String)("Remove " + (String)message))) == 2) {
            return;
        }
        List<VTMatch> matches = matchContext.getSelectedMatches();
        ClearMatchTagTask task = new ClearMatchTagTask(matchContext.getSession(), matches);
        new TaskLauncher((Task)task, (Component)component);
    }
}

