/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeState;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.archive.ArchiveUtils;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.editor.DataTypeEditorManager;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.IOException;
import javax.swing.tree.TreePath;

public class UnlockArchiveAction
extends DockingAction {
    public static final String ACTION_NAME = "Unlock Archive";
    private final DataTypeManagerPlugin plugin;

    public UnlockArchiveAction(DataTypeManagerPlugin plugin) {
        super(ACTION_NAME, plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Close For Editing"}, null, "FileEdit"));
        this.setEnabled(true);
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        TreePath[] selectionPaths = this.getSelectionPaths(context);
        return this.isOnlyFileArchivesSelected(selectionPaths);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        TreePath[] selectionPaths = this.getSelectionPaths(context);
        return this.isOnlyFileArchivesSelected(selectionPaths) && this.isOneOrMoreSelectedFileArchivesLocked(selectionPaths);
    }

    private boolean isOnlyFileArchivesSelected(TreePath[] selectionPaths) {
        if (selectionPaths.length == 0) {
            return false;
        }
        for (TreePath path : selectionPaths) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (node instanceof FileArchiveNode) continue;
            return false;
        }
        return true;
    }

    private boolean isOneOrMoreSelectedFileArchivesLocked(TreePath[] selectionPaths) {
        for (TreePath path : selectionPaths) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (!this.hasWriteLock((FileArchiveNode)node)) continue;
            return true;
        }
        return false;
    }

    private TreePath[] getSelectionPaths(ActionContext context) {
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        return selectionPaths;
    }

    private boolean hasWriteLock(FileArchiveNode fileArchiveNode) {
        FileArchive archive = (FileArchive)fileArchiveNode.getArchive();
        return archive.hasWriteLock();
    }

    public void actionPerformed(ActionContext context) {
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        GTreeState treeState = gTree.getTreeState();
        DataTypeEditorManager editorManager = this.plugin.getEditorManager();
        for (TreePath path : selectionPaths) {
            FileArchiveNode node = (FileArchiveNode)((Object)path.getLastPathComponent());
            FileArchive archive = (FileArchive)node.getArchive();
            if (!this.canReleaseLock(archive, (Component)gTree)) continue;
            FileDataTypeManager dataTypeManager = archive.getDataTypeManager();
            if (!editorManager.checkEditors((DataTypeManager)dataTypeManager, true)) {
                return;
            }
            if (!ArchiveUtils.canClose(archive, (Component)gTree)) {
                return;
            }
            editorManager.dismissEditors((DataTypeManager)dataTypeManager);
            this.releaseLock(archive);
        }
        gTree.restoreTreeState(treeState);
    }

    private boolean canReleaseLock(FileArchive archive, Component parent) {
        if (archive.getFile() == null) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)parent, (String)"Unsaved Archive", (Object)"Unsaved Archives must first be saved.");
            return false;
        }
        return true;
    }

    private void releaseLock(FileArchive archive) {
        try {
            archive.releaseWriteLock();
        }
        catch (IOException ioe) {
            Msg.showError((Object)((Object)this), (Component)this.plugin.getProvider().getComponent(), (String)"Unable to Release Write Lock", (Object)("Problem attempting to release write lock for archive: " + archive.getName() + "\nMessage: " + ioe.getMessage()), (Throwable)ioe);
        }
    }
}

