/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ProcessVmCountersStream
implements StructConverter {
    public static final String NAME = "MINIDUMP_PROCESS_VM_COUNTERS";
    private short revision;
    private short flags;
    private int pageFaultCount;
    private long peakWorkingSetSize;
    private long workingSetSize;
    private long quotaPeakPagedPoolUsage;
    private long quotaPagedPoolUsage;
    private long quotaPeakNonPagedPoolUsage;
    private long quotaNonPagedPoolUsage;
    private long pagefileUsage;
    private long peakPagefileUsage;
    private long peakVirtualSize;
    private long virtualSize;
    private long privateUsage;
    private long privateWorkingSetSize;
    private long sharedCommitUsage;
    private long jobSharedCommitUsage;
    private long jobPrivateCommitUsage;
    private long jobPeakPrivateCommitUsage;
    private long jobPrivateCommitLimit;
    private long jobTotalCommitLimit;
    private DumpFileReader reader;
    private long index;
    private boolean expandedFormat;

    ProcessVmCountersStream(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setRevision(this.reader.readNextShort());
        boolean bl = this.expandedFormat = this.getRevision() > 1;
        if (this.expandedFormat) {
            this.setFlags(this.reader.readNextShort());
        }
        this.setPageFaultCount(this.reader.readNextInt());
        this.setPeakWorkingSetSize(this.reader.readNextLong());
        this.setWorkingSetSize(this.reader.readNextLong());
        this.setQuotaPeakPagedPoolUsage(this.reader.readNextLong());
        this.setQuotaPagedPoolUsage(this.reader.readNextLong());
        this.setQuotaPeakNonPagedPoolUsage(this.reader.readNextLong());
        this.setQuotaNonPagedPoolUsage(this.reader.readNextLong());
        this.setPagefileUsage(this.reader.readNextLong());
        this.setPeakPagefileUsage(this.reader.readNextLong());
        if (this.expandedFormat) {
            this.setPeakVirtualSize(this.reader.readNextLong());
            this.setVirtualSize(this.reader.readNextLong());
        }
        this.setPrivateUsage(this.reader.readNextLong());
        if (this.expandedFormat) {
            this.setPrivateWorkingSetSize(this.reader.readNextLong());
            this.setSharedCommitUsage(this.reader.readNextLong());
            this.setJobSharedCommitUsage(this.reader.readNextLong());
            this.setJobPrivateCommitUsage(this.reader.readNextLong());
            this.setJobPeakPrivateCommitUsage(this.reader.readNextLong());
            this.setJobPrivateCommitLimit(this.reader.readNextLong());
            this.setJobTotalCommitLimit(this.reader.readNextLong());
        }
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(WORD, 2, "Revision", null);
        if (this.expandedFormat) {
            struct.add(WORD, 2, "Flags", null);
        }
        struct.add(DWORD, 4, "PageFaultCount", null);
        struct.add(QWORD, 8, "PeakWorkingSetSize", null);
        struct.add(QWORD, 8, "WorkingSetSize", null);
        struct.add(QWORD, 8, "QuotaPeakPagedPoolUsage", null);
        struct.add(QWORD, 8, "QuotaPagedPoolUsage", null);
        struct.add(QWORD, 8, "QuotaPeakNonPagedPoolUsage", null);
        struct.add(QWORD, 8, "QuotaNonPagedPoolUsage", null);
        struct.add(QWORD, 8, "PagefileUsage", null);
        struct.add(QWORD, 8, "PeakPagefileUsage", null);
        if (this.expandedFormat) {
            struct.add(QWORD, 8, "PeakVirtualSize", null);
            struct.add(QWORD, 8, "VirtualSize", null);
        }
        struct.add(QWORD, 8, "PrivateUsage", null);
        if (this.expandedFormat) {
            struct.add(QWORD, 8, "PrivateWorkingSetSize", null);
            struct.add(QWORD, 8, "SharedCommitUsage", null);
            struct.add(QWORD, 8, "JobSharedCommitUsage", null);
            struct.add(QWORD, 8, "JobPrivateCommitUsage", null);
            struct.add(QWORD, 8, "JobPeakPrivateCommitUsage", null);
            struct.add(QWORD, 8, "JobPrivateCommitLimit", null);
            struct.add(QWORD, 8, "JobTotalCommitLimit", null);
        }
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public short getRevision() {
        return this.revision;
    }

    public void setRevision(short revision) {
        this.revision = revision;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public int getPageFaultCount() {
        return this.pageFaultCount;
    }

    public void setPageFaultCount(int pageFaultCount) {
        this.pageFaultCount = pageFaultCount;
    }

    public long getPeakWorkingSetSize() {
        return this.peakWorkingSetSize;
    }

    public void setPeakWorkingSetSize(long peakWorkingSetSize) {
        this.peakWorkingSetSize = peakWorkingSetSize;
    }

    public long getWorkingSetSize() {
        return this.workingSetSize;
    }

    public void setWorkingSetSize(long workingSetSize) {
        this.workingSetSize = workingSetSize;
    }

    public long getQuotaPeakPagedPoolUsage() {
        return this.quotaPeakPagedPoolUsage;
    }

    public void setQuotaPeakPagedPoolUsage(long quotaPeakPagedPoolUsage) {
        this.quotaPeakPagedPoolUsage = quotaPeakPagedPoolUsage;
    }

    public long getQuotaPagedPoolUsage() {
        return this.quotaPagedPoolUsage;
    }

    public void setQuotaPagedPoolUsage(long quotaPagedPoolUsage) {
        this.quotaPagedPoolUsage = quotaPagedPoolUsage;
    }

    public long getQuotaPeakNonPagedPoolUsage() {
        return this.quotaPeakNonPagedPoolUsage;
    }

    public void setQuotaPeakNonPagedPoolUsage(long quotaPeakNonPagedPoolUsage) {
        this.quotaPeakNonPagedPoolUsage = quotaPeakNonPagedPoolUsage;
    }

    public long getQuotaNonPagedPoolUsage() {
        return this.quotaNonPagedPoolUsage;
    }

    public void setQuotaNonPagedPoolUsage(long quotaNonPagedPoolUsage) {
        this.quotaNonPagedPoolUsage = quotaNonPagedPoolUsage;
    }

    public long getPagefileUsage() {
        return this.pagefileUsage;
    }

    public void setPagefileUsage(long pagefileUsage) {
        this.pagefileUsage = pagefileUsage;
    }

    public long getPeakPagefileUsage() {
        return this.peakPagefileUsage;
    }

    public void setPeakPagefileUsage(long peakPagefileUsage) {
        this.peakPagefileUsage = peakPagefileUsage;
    }

    public long getPeakVirtualSize() {
        return this.peakVirtualSize;
    }

    public void setPeakVirtualSize(long peakVirtualSize) {
        this.peakVirtualSize = peakVirtualSize;
    }

    public long getVirtualSize() {
        return this.virtualSize;
    }

    public void setVirtualSize(long virtualSize) {
        this.virtualSize = virtualSize;
    }

    public long getPrivateUsage() {
        return this.privateUsage;
    }

    public void setPrivateUsage(long privateUsage) {
        this.privateUsage = privateUsage;
    }

    public long getPrivateWorkingSetSize() {
        return this.privateWorkingSetSize;
    }

    public void setPrivateWorkingSetSize(long privateWorkingSetSize) {
        this.privateWorkingSetSize = privateWorkingSetSize;
    }

    public long getSharedCommitUsage() {
        return this.sharedCommitUsage;
    }

    public void setSharedCommitUsage(long sharedCommitUsage) {
        this.sharedCommitUsage = sharedCommitUsage;
    }

    public long getJobSharedCommitUsage() {
        return this.jobSharedCommitUsage;
    }

    public void setJobSharedCommitUsage(long jobSharedCommitUsage) {
        this.jobSharedCommitUsage = jobSharedCommitUsage;
    }

    public long getJobPrivateCommitUsage() {
        return this.jobPrivateCommitUsage;
    }

    public void setJobPrivateCommitUsage(long jobPrivateCommitUsage) {
        this.jobPrivateCommitUsage = jobPrivateCommitUsage;
    }

    public long getJobPeakPrivateCommitUsage() {
        return this.jobPeakPrivateCommitUsage;
    }

    public void setJobPeakPrivateCommitUsage(long jobPeakPrivateCommitUsage) {
        this.jobPeakPrivateCommitUsage = jobPeakPrivateCommitUsage;
    }

    public long getJobPrivateCommitLimit() {
        return this.jobPrivateCommitLimit;
    }

    public void setJobPrivateCommitLimit(long jobPrivateCommitLimit) {
        this.jobPrivateCommitLimit = jobPrivateCommitLimit;
    }

    public long getJobTotalCommitLimit() {
        return this.jobTotalCommitLimit;
    }

    public void setJobTotalCommitLimit(long jobTotalCommitLimit) {
        this.jobTotalCommitLimit = jobTotalCommitLimit;
    }
}

