/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CodeUnitLocation;
import java.util.Arrays;

public class CommentFieldLocation
extends CodeUnitLocation {
    protected String[] comment;
    protected CommentType type;

    public CommentFieldLocation(Program program, Address addr, int[] componentPath, String[] comment, CommentType type, int row, int charOffset) {
        super(program, addr, componentPath, row, 0, charOffset);
        this.comment = comment;
        if (comment == null) {
            this.comment = new String[0];
        }
        this.type = type;
    }

    public CommentFieldLocation() {
    }

    public String[] getComment() {
        return this.comment;
    }

    public CommentType getCommentType() {
        return this.type;
    }

    @Override
    public String toString() {
        String str = this.type != null ? this.type.name() : "NO-COMMENT";
        return super.toString() + ", Comment Type = " + str;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.comment);
        if (this.type != null) {
            result = 31 * result + this.type.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommentFieldLocation other = (CommentFieldLocation)obj;
        if (!Arrays.equals(this.comment, other.comment)) {
            return false;
        }
        return this.type == other.type;
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putStrings("_COMMENT", this.comment);
        obj.putInt("_TYPE", this.type != null ? this.type.ordinal() : -1);
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.comment = obj.getStrings("_COMMENT", new String[0]);
        int commentType = obj.getInt("_TYPE", CommentType.EOL.ordinal());
        this.type = commentType < 0 ? null : CommentType.valueOf(commentType);
    }
}

