/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.pathmanager;

import docking.widgets.pathmanager.PathManager;
import docking.widgets.pathmanager.PathManagerListener;
import generic.util.Path;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class PathManagerModel
extends AbstractTableModel {
    static final int COLUMN_USE = 0;
    static final int COLUMN_PATH = 1;
    private PathManager mgr;
    private List<Path> paths = new ArrayList<Path>();

    PathManagerModel(PathManager mgr, List<Path> paths) {
        this.mgr = mgr;
        this.paths.addAll(this.dedupPaths(paths));
        this.fireTableDataChanged();
    }

    private List<Path> dedupPaths(List<Path> newPaths) {
        ArrayList<Path> dedupedPaths = new ArrayList<Path>();
        for (Path path : newPaths) {
            if (dedupedPaths.contains(path)) continue;
            dedupedPaths.add(path);
        }
        return dedupedPaths;
    }

    void clear() {
        this.paths.clear();
    }

    List<Path> getAllPaths() {
        return new ArrayList<Path>(this.paths);
    }

    List<Path> getPaths() {
        ArrayList<Path> list = new ArrayList<Path>();
        for (Path path : this.paths) {
            if (!path.isEnabled()) continue;
            list.add(path);
        }
        return list;
    }

    void setPaths(List<Path> paths) {
        this.paths = new ArrayList<Path>(paths);
        this.fireTableDataChanged();
    }

    void setPaths(Path[] pathsArr) {
        this.paths.clear();
        this.paths = new ArrayList<Path>();
        for (int i = 0; i < pathsArr.length; ++i) {
            this.paths.add(pathsArr[i]);
        }
        this.fireTableDataChanged();
    }

    void addPath(Path path, boolean addToTop) {
        if (this.paths.contains(path)) {
            return;
        }
        if (addToTop) {
            this.paths.add(0, path);
            this.fireTableRowsInserted(0, 0);
        } else {
            int index = this.paths.size();
            this.paths.add(path);
            this.fireTableRowsInserted(index, index);
        }
    }

    void removePath(Path path) {
        int index = this.paths.indexOf(path);
        if (path.isEditable()) {
            this.paths.remove(path);
        } else {
            List<PathManagerListener> listeners = this.mgr.getListeners();
            for (PathManagerListener listener : listeners) {
                listener.pathMessage("Unable to remove path.");
            }
        }
        this.fireTableRowsDeleted(index, index);
    }

    void remove(int[] selectedRows) {
        ArrayList<Path> list = new ArrayList<Path>();
        for (int i = 0; i < selectedRows.length; ++i) {
            list.add(this.paths.get(selectedRows[i]));
        }
        for (Path path : list) {
            if (path.isEditable()) {
                this.paths.remove(path);
                continue;
            }
            List<PathManagerListener> listeners = this.mgr.getListeners();
            for (PathManagerListener listener : listeners) {
                listener.pathMessage("Unable to remove path.");
            }
        }
        this.fireTableDataChanged();
    }

    int moveUp(int index) {
        if (index < 0 || index >= this.paths.size()) {
            return -1;
        }
        Path path = this.paths.remove(index);
        if (index == 0) {
            this.paths.add(path);
        } else {
            this.paths.add(index - 1, path);
        }
        this.fireTableDataChanged();
        return this.paths.indexOf(path);
    }

    int moveDown(int index) {
        if (index < 0 || index >= this.paths.size()) {
            return -1;
        }
        int size = this.paths.size();
        Path path = this.paths.remove(index);
        if (index == size - 1) {
            this.paths.add(0, path);
        } else {
            this.paths.add(index + 1, path);
        }
        this.fireTableDataChanged();
        return this.paths.indexOf(path);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Path.class;
            }
        }
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.paths.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Path path = this.paths.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return true;
            }
            case 1: {
                return path.isEditable();
            }
        }
        return true;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Use";
            }
            case 1: {
                return "Path";
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Path path = this.paths.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return path.isEnabled();
            }
            case 1: {
                return path;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Path path = this.paths.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                path.setEnabled(((Boolean)aValue).booleanValue());
                break;
            }
            case 1: {
                if (!path.isEditable()) break;
                Path newpath = (Path)aValue;
                path.setPath(newpath.getPath());
            }
        }
        this.fireTableDataChanged();
    }
}

