/*
 * Decompiled with CFR 0.152.
 */
package db.buffers;

import db.ChainedBuffer;
import db.buffers.BufferMgr;
import db.buffers.LocalBufferFile;
import db.buffers.LocalManagedBufferFile;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;

public class ChangeMapFile {
    private static final int MAGIC_NUMBER = 1943643068;
    private static final int CACHE_SIZE = 65536;
    private static final String MODMAP_PARM_PREFIX = "~MF.";
    private static final String MAGIC_NUMBER_PARM = "~MF.ModMapFile";
    private static final String BUFFER_ID_PARM = "~MF.BufferId";
    private static final String TARGET_FILE_ID_HI_PARM = "~MF.TargetIdHi";
    private static final String TARGET_FILE_ID_LOW_PARM = "~MF.TargetIdLow";
    private static final String INDEX_CNT_PARM = "~MF.IndexCnt";
    private static final String INITIAL_VERSION_PARM = "~MF.InitialVersion";
    private File file;
    private BufferMgr bufMgr;
    private ChainedBuffer buffer;
    private int indexCnt;
    private boolean readOnly;

    ChangeMapFile(File file, LocalManagedBufferFile oldFile, LocalManagedBufferFile newFile) throws IOException {
        this.file = file;
        this.readOnly = false;
        LocalBufferFile mapFile = null;
        boolean success = false;
        try {
            if (!file.exists()) {
                int bit;
                this.indexCnt = oldFile.getIndexCount();
                this.bufMgr = new BufferMgr(16384, 65536L, 1);
                this.bufMgr.setParameter(MAGIC_NUMBER_PARM, 1943643068);
                int ver = oldFile.getVersion();
                this.bufMgr.setParameter(INITIAL_VERSION_PARM, ver);
                this.bufMgr.setParameter(INDEX_CNT_PARM, this.indexCnt);
                int size = (this.indexCnt - 1) / 8 + 1;
                this.buffer = new ChainedBuffer(size, this.bufMgr);
                this.bufMgr.setParameter(BUFFER_ID_PARM, this.buffer.getId());
                int lastByteOffset = (this.indexCnt - 1) / 8;
                byte lastByte = 0;
                int index = this.indexCnt;
                while ((bit = index % 8) != 0) {
                    int bitMask = 1 << bit;
                    lastByte = (byte)(lastByte | bitMask);
                    ++index;
                }
                this.buffer.putByte(lastByteOffset, lastByte);
            } else {
                mapFile = new LocalBufferFile(file, true);
                if (mapFile.getParameter(MAGIC_NUMBER_PARM) != 1943643068) {
                    throw new IOException("Bad modification map file: " + String.valueOf(file));
                }
                long oldTargetFileId = (long)mapFile.getParameter(TARGET_FILE_ID_HI_PARM) << 32 | (long)mapFile.getParameter(TARGET_FILE_ID_LOW_PARM) & 0xFFFFFFFFL;
                if (oldTargetFileId != oldFile.getFileId()) {
                    throw new IOException("Modification map file does not correspond to target: " + String.valueOf(file));
                }
                this.bufMgr = new BufferMgr(mapFile, 65536L, 1);
                this.indexCnt = this.bufMgr.getParameter(INDEX_CNT_PARM);
                if (newFile.getIndexCount() < this.indexCnt) {
                    throw new AssertException();
                }
                int id = this.bufMgr.getParameter(BUFFER_ID_PARM);
                this.buffer = new ChainedBuffer(this.bufMgr, id);
            }
            long targetFileId = newFile.getFileId();
            this.bufMgr.setParameter(TARGET_FILE_ID_HI_PARM, (int)(targetFileId >> 32));
            this.bufMgr.setParameter(TARGET_FILE_ID_LOW_PARM, (int)(targetFileId & 0xFFFFFFFFL));
            success = true;
        }
        catch (NoSuchElementException e) {
            throw new IOException("Required modification map paramater (" + e.getMessage() + ") not found: " + String.valueOf(file));
        }
        finally {
            if (!success) {
                if (this.bufMgr != null) {
                    this.bufMgr.dispose();
                } else if (mapFile != null) {
                    mapFile.dispose();
                }
            }
        }
    }

    ChangeMapFile(File file, LocalBufferFile targetFile) throws IOException {
        this.file = file;
        this.readOnly = true;
        LocalBufferFile mapFile = null;
        boolean success = false;
        try {
            mapFile = new LocalBufferFile(file, true);
            if (mapFile.getParameter(MAGIC_NUMBER_PARM) != 1943643068) {
                throw new IOException("Bad modification map file: " + String.valueOf(file));
            }
            long oldTargetFileId = (long)mapFile.getParameter(TARGET_FILE_ID_HI_PARM) << 32 | (long)mapFile.getParameter(TARGET_FILE_ID_LOW_PARM) & 0xFFFFFFFFL;
            if (oldTargetFileId != targetFile.getFileId()) {
                throw new IOException("Modification map file does not correspond to target: " + String.valueOf(file));
            }
            this.bufMgr = new BufferMgr(mapFile, 65536L, 1);
            this.indexCnt = this.bufMgr.getParameter(INDEX_CNT_PARM);
            if (targetFile.getIndexCount() < this.indexCnt) {
                throw new AssertException();
            }
            int id = this.bufMgr.getParameter(BUFFER_ID_PARM);
            this.buffer = new ChainedBuffer(this.bufMgr, id);
            success = true;
        }
        catch (NoSuchElementException e) {
            throw new IOException("Required modification map paramater (" + e.getMessage() + ") not found: " + String.valueOf(file));
        }
        finally {
            if (!success) {
                if (this.bufMgr != null) {
                    this.bufMgr.dispose();
                } else if (mapFile != null) {
                    mapFile.dispose();
                }
            }
        }
    }

    boolean isValidFor(LocalBufferFile targetFile) {
        long targetFileId = (long)this.bufMgr.getParameter(TARGET_FILE_ID_HI_PARM) << 32 | (long)this.bufMgr.getParameter(TARGET_FILE_ID_LOW_PARM) & 0xFFFFFFFFL;
        return targetFileId == targetFile.getFileId();
    }

    void abort() {
        if (this.bufMgr != null) {
            this.bufMgr.dispose();
            this.bufMgr = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        LocalBufferFile mapFile = null;
        boolean success = false;
        try {
            if (!this.readOnly) {
                File tmpFile = new File(this.file.getParentFile(), this.file.getName() + ".tmp");
                mapFile = new LocalBufferFile(tmpFile, this.bufMgr.getBufferSize());
                this.bufMgr.saveAs(mapFile, true, null);
                this.bufMgr.dispose();
                this.bufMgr = null;
                this.file.delete();
                if (!tmpFile.renameTo(this.file)) {
                    throw new IOException("Failed to update file: " + String.valueOf(this.file));
                }
            } else {
                this.bufMgr.dispose();
                this.bufMgr = null;
            }
            success = true;
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            if (!success) {
                if (mapFile != null) {
                    mapFile.delete();
                }
                if (this.bufMgr != null) {
                    this.bufMgr.dispose();
                }
            }
        }
    }

    void bufferChanged(int index, boolean empty) throws IOException {
        byte b;
        if (index >= this.indexCnt) {
            return;
        }
        int byteOffset = index / 8;
        if (empty) {
            int bitMask = ~(1 << index % 8);
            b = (byte)(this.buffer.getByte(byteOffset) & bitMask);
        } else {
            int bitMask = 1 << index % 8;
            b = (byte)(this.buffer.getByte(byteOffset) | bitMask);
        }
        this.buffer.putByte(byteOffset, b);
    }

    byte[] getModData() throws IOException {
        return this.buffer.get(0, this.buffer.length());
    }
}

