/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.flags;

public enum MethodsInfoAccessFlags {
    ACC_PUBLIC(1),
    ACC_PRIVATE(2),
    ACC_PROTECTED(4),
    ACC_STATIC(8),
    ACC_FINAL(16),
    ACC_SYNCHRONIZED(32),
    ACC_BRIDGE(64),
    ACC_VARARGS(128),
    ACC_NATIVE(256),
    ACC_ABSTRACT(1024),
    ACC_STRICT(2048),
    ACC_SYNTHETIC(4096);

    private final int value;

    private MethodsInfoAccessFlags(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static String toString(int access) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((access & MethodsInfoAccessFlags.ACC_PUBLIC.value) == MethodsInfoAccessFlags.ACC_PUBLIC.value) {
            stringBuffer.append("public ");
        }
        if ((access & MethodsInfoAccessFlags.ACC_PRIVATE.value) == MethodsInfoAccessFlags.ACC_PRIVATE.value) {
            stringBuffer.append("private ");
        }
        if ((access & MethodsInfoAccessFlags.ACC_PROTECTED.value) == MethodsInfoAccessFlags.ACC_PROTECTED.value) {
            stringBuffer.append("protected ");
        }
        if ((access & MethodsInfoAccessFlags.ACC_STATIC.value) == MethodsInfoAccessFlags.ACC_STATIC.value) {
            stringBuffer.append("static ");
        }
        if ((access & MethodsInfoAccessFlags.ACC_FINAL.value) == MethodsInfoAccessFlags.ACC_FINAL.value) {
            stringBuffer.append("final ");
        }
        if ((access & MethodsInfoAccessFlags.ACC_SYNCHRONIZED.value) == MethodsInfoAccessFlags.ACC_SYNCHRONIZED.value) {
            stringBuffer.append("synchronized ");
        }
        if ((access & MethodsInfoAccessFlags.ACC_NATIVE.value) == MethodsInfoAccessFlags.ACC_NATIVE.value) {
            stringBuffer.append("native ");
        }
        if ((access & MethodsInfoAccessFlags.ACC_ABSTRACT.value) == MethodsInfoAccessFlags.ACC_ABSTRACT.value) {
            stringBuffer.append("abstract ");
        }
        return stringBuffer.toString().trim();
    }
}

