/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.util;

import java.util.ConcurrentModificationException;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.util.VertexAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadiusVertexAccessor<V>
implements VertexAccessor<V> {
    private static final Logger log = LoggerFactory.getLogger(RadiusVertexAccessor.class);
    protected double maxDistance;

    public RadiusVertexAccessor() {
        this(Math.sqrt(Double.MAX_VALUE));
    }

    public RadiusVertexAccessor(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    @Override
    public V getVertex(LayoutModel<V> layoutModel, Point p) {
        return this.getVertex(layoutModel, p.x, p.y);
    }

    @Override
    public V getVertex(LayoutModel<V> layoutModel, double x, double y) {
        double minDistance = this.maxDistance * this.maxDistance * this.maxDistance;
        V closest = null;
        while (true) {
            try {
                for (Object vertex : layoutModel.getGraph().vertexSet()) {
                    Point p = (Point)layoutModel.apply(vertex);
                    double dx = p.x - x;
                    double dy = p.y - y;
                    double dist = dx * dx + dy * dy;
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                    closest = (V)vertex;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }

    @Override
    public V getClosestVertex(LayoutModel<V> layoutModel, V v) {
        Point vp = layoutModel.get(v);
        double minDistance = this.maxDistance * this.maxDistance * this.maxDistance;
        V closest = null;
        while (true) {
            try {
                for (Object vertex : layoutModel.getGraph().vertexSet()) {
                    if (vertex == v) continue;
                    Point p = (Point)layoutModel.apply(vertex);
                    double dx = p.x - vp.x;
                    double dy = p.y - vp.y;
                    double dist = dx * dx + dy * dy;
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                    closest = (V)vertex;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }
}

