/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.pef.PackedDataOpcodes;
import ghidra.app.util.bin.format.pef.SectionKind;
import ghidra.app.util.bin.format.pef.SectionShareKind;
import ghidra.program.model.data.DataType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;

public class SectionHeader
implements StructConverter {
    public static final int NO_NAME_OFFSET = -1;
    private BinaryReader _reader;
    private String _name;
    private int nameOffset;
    private int defaultAddress;
    private int totalLength;
    private int unpackedLength;
    private int containerLength;
    private int containerOffset;
    private byte sectionKind;
    private byte shareKind;
    private byte alignment;
    private byte reservedA;

    SectionHeader(BinaryReader reader) throws IOException {
        this._reader = reader;
        this.nameOffset = reader.readNextInt();
        this.defaultAddress = reader.readNextInt();
        this.totalLength = reader.readNextInt();
        this.unpackedLength = reader.readNextInt();
        this.containerLength = reader.readNextInt();
        this.containerOffset = reader.readNextInt();
        this.sectionKind = reader.readNextByte();
        this.shareKind = reader.readNextByte();
        this.alignment = reader.readNextByte();
        this.reservedA = reader.readNextByte();
        if (this.nameOffset != -1) {
            Msg.debug((Object)this, (Object)"PEF- Named Section");
        }
    }

    public int getNameOffset() {
        return this.nameOffset;
    }

    public String getName() {
        if (this._name == null) {
            return this.getSectionKind().toString();
        }
        return this._name;
    }

    public InputStream getData() throws IOException {
        return this._reader.getByteProvider().getInputStream(this.containerOffset);
    }

    public byte[] getUnpackedData(TaskMonitor monitor) throws IOException {
        if (this.getSectionKind() != SectionKind.PackedData) {
            throw new IOException("Attempt to unpack a section that is not packed.");
        }
        try (InputStream input = this.getData();){
            byte[] data = new byte[this.getUnpackedLength()];
            int index = 0;
            while (index < data.length && !monitor.isCancelled()) {
                int repeatCount;
                int customSize;
                int i;
                PackedDataOpcodes opcode;
                int value = input.read();
                if (value == -1) {
                    throw new IllegalStateException();
                }
                int count = value & 0x1F;
                if (count == 0) {
                    count = this.unpackNextValue(input);
                }
                if ((opcode = PackedDataOpcodes.get(value >> 5)) == PackedDataOpcodes.kPEFPkDataZero) {
                    index += count;
                    continue;
                }
                if (opcode == PackedDataOpcodes.kPEFPkDataBlock) {
                    byte[] rawData = new byte[count];
                    int nRead = input.read(rawData);
                    if (nRead != count) {
                        throw new IllegalStateException("Unable to read enough bytes for " + String.valueOf((Object)opcode));
                    }
                    System.arraycopy(rawData, 0, data, index, rawData.length);
                    index += rawData.length;
                    continue;
                }
                if (opcode == PackedDataOpcodes.kPEFPkDataRepeat) {
                    int repeatCount2 = this.unpackNextValue(input);
                    byte[] rawData = new byte[count];
                    int nRead = input.read(rawData);
                    if (nRead != rawData.length) {
                        throw new IllegalStateException("Unable to read enough bytes for " + String.valueOf((Object)opcode));
                    }
                    for (i = 0; i < repeatCount2 + 1; ++i) {
                        System.arraycopy(rawData, 0, data, index, rawData.length);
                        index += rawData.length;
                    }
                    continue;
                }
                if (opcode == PackedDataOpcodes.kPEFPkDataRepeatBlock) {
                    int commonSize = count;
                    customSize = this.unpackNextValue(input);
                    repeatCount = this.unpackNextValue(input);
                    byte[] commonData = new byte[commonSize];
                    int nCommonRead = input.read(commonData);
                    if (nCommonRead != commonData.length) {
                        throw new IllegalStateException("Unable to read enough common data bytes for " + String.valueOf((Object)opcode));
                    }
                    for (int i2 = 0; i2 < repeatCount; ++i2) {
                        System.arraycopy(commonData, 0, data, index, commonData.length);
                        index += commonData.length;
                        byte[] customData = new byte[customSize];
                        int nCustomRead = input.read(customData);
                        if (nCustomRead != customData.length) {
                            throw new IllegalStateException("Unable to read enough custom data bytes for " + String.valueOf((Object)opcode));
                        }
                        System.arraycopy(customData, 0, data, index, customData.length);
                        index += customData.length;
                    }
                    System.arraycopy(commonData, 0, data, index, commonData.length);
                    index += commonData.length;
                    continue;
                }
                if (opcode == PackedDataOpcodes.kPEFPkDataRepeatZero) {
                    int commonSize = count;
                    customSize = this.unpackNextValue(input);
                    repeatCount = this.unpackNextValue(input);
                    for (i = 0; i < repeatCount; ++i) {
                        index += commonSize;
                        byte[] customData = new byte[customSize];
                        int nCustomRead = input.read(customData);
                        if (nCustomRead != customData.length) {
                            throw new IllegalStateException("Unable to read enough custom data bytes for " + String.valueOf((Object)opcode));
                        }
                        System.arraycopy(customData, 0, data, index, customData.length);
                        index += customData.length;
                    }
                    index += commonSize;
                    continue;
                }
                Msg.error((Object)this, (Object)("Unrecognized packed data opcode: " + String.valueOf((Object)opcode)));
            }
            byte[] byArray = data;
            return byArray;
        }
    }

    private int unpackNextValue(InputStream input) throws IOException {
        int value;
        int unpacked = 0;
        do {
            unpacked <<= 7;
            value = input.read();
            unpacked += value & 0x7F;
        } while ((value & 0x80) != 0);
        return unpacked;
    }

    public int getDefaultAddress() {
        return this.defaultAddress;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public int getUnpackedLength() {
        return this.unpackedLength;
    }

    public int getContainerLength() {
        return this.containerLength;
    }

    public int getContainerOffset() {
        return this.containerOffset;
    }

    public SectionKind getSectionKind() {
        return SectionKind.get(this.sectionKind);
    }

    public SectionShareKind getShareKind() {
        return SectionShareKind.get(this.shareKind);
    }

    public byte getAlignment() {
        return this.alignment;
    }

    public byte getReservedA() {
        return this.reservedA;
    }

    public boolean isRead() {
        return true;
    }

    public boolean isWrite() {
        SectionKind kind = this.getSectionKind();
        return kind == SectionKind.UnpackedData || kind == SectionKind.PackedData || kind == SectionKind.ExecutableData;
    }

    public boolean isExecute() {
        SectionKind kind = this.getSectionKind();
        return kind == SectionKind.Code || kind == SectionKind.ExecutableData;
    }

    public String toString() {
        return "Name=" + this._name + " Kind=" + String.valueOf((Object)this.getSectionKind()) + " Share=" + String.valueOf((Object)this.getShareKind());
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(this.getClass());
    }
}

