/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import ghidra.app.plugin.core.navigation.FindAppliedDataTypesService;
import ghidra.app.services.FieldMatcher;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;

public abstract class AbstractFindReferencesToFieldAction
extends DockingAction {
    public static final String BASE_ACTION_NAME = "Find Uses of";
    private Plugin plugin;

    public AbstractFindReferencesToFieldAction(Plugin plugin) {
        super(BASE_ACTION_NAME, plugin.getName(), KeyBindingType.SHARED);
        this.plugin = plugin;
        String menuGroup = "ZVeryLast";
        this.setPopupMenuData(new MenuData(new String[]{"Find Uses of Field..."}, null, menuGroup));
        this.setHelpLocation(new HelpLocation("LocationReferencesPlugin", "Data_Types"));
    }

    protected abstract DataTypeAndFields getSelectedType(ActionContext var1);

    protected abstract FieldMatcher createFieldMatcher(DataTypeAndFields var1);

    public boolean isEnabledForContext(ActionContext context) {
        return this.getSelectedType(context) != null;
    }

    public void actionPerformed(ActionContext context) {
        PluginTool serviceProvider = this.plugin.getTool();
        FindAppliedDataTypesService service = (FindAppliedDataTypesService)serviceProvider.getService(FindAppliedDataTypesService.class);
        if (service == null) {
            Msg.showError((Object)((Object)this), null, (String)"Missing Plugin", (Object)"The %s is not installed.\nPlease add the plugin implementing this service.".formatted(FindAppliedDataTypesService.class.getSimpleName()));
            return;
        }
        DataTypeAndFields typeAndFields = this.getSelectedType(context);
        FieldMatcher fieldMatcher = this.createFieldMatcher(typeAndFields);
        if (fieldMatcher == null) {
            return;
        }
        DataType dt = fieldMatcher.getDataType();
        Swing.runLater(() -> service.findAndDisplayAppliedDataTypeAddresses(dt, fieldMatcher));
    }

    public record DataTypeAndFields(DataType dataType, String[] fieldNames) {
    }
}

