/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust.demangler;

import ghidra.app.plugin.core.analysis.rust.demangler.RustIdentifier;
import ghidra.app.plugin.core.analysis.rust.demangler.RustPath;
import ghidra.app.plugin.core.analysis.rust.demangler.RustString;
import ghidra.app.plugin.core.analysis.rust.demangler.Symbol;
import ghidra.app.plugin.core.analysis.rust.demangler.SymbolNode;

class RustImplPath
implements SymbolNode {
    RustPath path;
    RustString disambiguator;

    public RustImplPath(RustPath path, RustString disambiguator) {
        this.path = path;
        this.disambiguator = disambiguator;
    }

    public static RustImplPath parse(Symbol s) {
        RustString disambiguator = null;
        if (s.nextChar() == 's') {
            disambiguator = RustIdentifier.parseDisambiguator(s);
        }
        RustPath path = RustPath.parse(s);
        return new RustImplPath(path, disambiguator);
    }

    public String toString() {
        Object s = this.path.toString();
        if (this.disambiguator != null && this.disambiguator.toString() != "") {
            s = (String)s + "::[" + this.disambiguator.toString() + "]";
        }
        return s;
    }
}

