/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RegisterName;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;

public class StaticLinkForMipsExceptionHandlingMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 527;
    private long framesize;
    private long offset;
    private int register;
    private RegisterName registerName;

    public StaticLinkForMipsExceptionHandlingMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.framesize = reader.parseUnsignedIntVal();
        this.offset = reader.parseInt();
        this.register = reader.parseUnsignedShortVal();
        this.registerName = new RegisterName(pdb, this.register);
    }

    @Override
    public int getPdbId() {
        return 527;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: framesize = %08X, offset = %08X, register = %s", this.getSymbolTypeName(), this.framesize, this.offset, this.registerName.toString()));
    }

    @Override
    protected String getSymbolTypeName() {
        return "SLINK32";
    }
}

