/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import ghidra.framework.options.Options;
import ghidra.framework.options.PreferenceState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.graph.visualization.DefaultGraphDisplay;
import ghidra.graph.visualization.DefaultGraphDisplayWrapper;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.DefaultGraphDisplayOptions;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayOptions;
import ghidra.service.graph.GraphDisplayProvider;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;

public class DefaultGraphDisplayProvider
implements GraphDisplayProvider {
    private static final String PREFERENCES_KEY = "GRAPH_DISPLAY_SERVICE";
    private static final String DEFAULT_SATELLITE_STATE = "DEFAULT_SATELLITE_STATE";
    private final Set<DefaultGraphDisplayWrapper> displays = new CopyOnWriteArraySet<DefaultGraphDisplayWrapper>();
    private PluginTool pluginTool;
    private Options options;
    private int displayCounter = 1;
    private boolean defaultSatelliteState;
    private PreferenceState preferences;

    public String getName() {
        return "Default Graph Display";
    }

    public PluginTool getPluginTool() {
        return this.pluginTool;
    }

    public Options getOptions() {
        return this.options;
    }

    public GraphDisplay getGraphDisplay(boolean reuseGraph, TaskMonitor monitor) {
        return (GraphDisplay)Swing.runNow(() -> {
            if (reuseGraph && !this.displays.isEmpty()) {
                DefaultGraphDisplayWrapper visibleGraph = (DefaultGraphDisplayWrapper)this.getActiveGraphDisplay();
                visibleGraph.setGraph(new AttributedGraph("Empty", null), (GraphDisplayOptions)new DefaultGraphDisplayOptions(), "", false, monitor);
                visibleGraph.restoreDefaultState();
                return visibleGraph;
            }
            DefaultGraphDisplayWrapper display = new DefaultGraphDisplayWrapper(this, this.displayCounter++);
            this.displays.add(display);
            return display;
        });
    }

    public GraphDisplay getActiveGraphDisplay() {
        if (this.displays.isEmpty()) {
            return null;
        }
        return this.getAllGraphDisplays().get(0);
    }

    public List<GraphDisplay> getAllGraphDisplays() {
        return this.displays.stream().sorted().collect(Collectors.toList());
    }

    public void initialize(PluginTool tool, Options graphOptions) {
        this.pluginTool = tool;
        this.options = graphOptions;
        Swing.assertSwingThread((String)"Graph preferences must be accessed on the Swing thread");
        this.preferences = this.pluginTool.getWindowManager().getPreferenceState(PREFERENCES_KEY);
        if (this.preferences == null) {
            this.preferences = new PreferenceState();
            this.pluginTool.getWindowManager().putPreferenceState(PREFERENCES_KEY, this.preferences);
        }
        this.defaultSatelliteState = this.preferences.getBoolean(DEFAULT_SATELLITE_STATE, false);
    }

    public void optionsChanged(Options graphOptions) {
    }

    public void dispose() {
        HashSet<DefaultGraphDisplayWrapper> set = new HashSet<DefaultGraphDisplayWrapper>(this.displays);
        this.displays.clear();
        set.forEach(d -> d.close());
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation("GraphServices", "Default_Graph_Display");
    }

    void remove(DefaultGraphDisplay defaultGraphDisplay) {
        this.displays.removeIf(wrapper -> wrapper.isDelegate(defaultGraphDisplay));
    }

    boolean getDefaultSatelliteState() {
        return this.defaultSatelliteState;
    }

    void setDefaultSatelliteState(boolean b) {
        Swing.assertSwingThread((String)"Graph preferences must be accessed on the Swing thread");
        this.defaultSatelliteState = b;
        this.preferences.putBoolean(DEFAULT_SATELLITE_STATE, b);
    }
}

