/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.pagedump;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class UnloadedDriver
implements StructConverter {
    public static final String NAME = "_DUMP_UNLOADED_DRIVERS";
    private int nameLength;
    private String name;
    private long startAddress;
    private long endAddress;
    private DumpFileReader reader;
    private long index;
    private int psz;

    UnloadedDriver(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.psz = reader.getPointerSize();
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setNameLength(this.reader.readNextShort());
        this.reader.readNextShort();
        this.reader.readNextInt();
        this.reader.readNextPointer();
        this.setName(this.reader.readNextUnicodeString(12));
        this.setStartAddress(this.reader.readNextPointer());
        this.setEndAddress(this.reader.readNextPointer());
    }

    public DataType toDataType() {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(WORD, 2, "NameLength", null);
        struct.add(WORD, 2, "", null);
        struct.add(DWORD, 4, "", null);
        struct.add(POINTER, this.psz, "", null);
        struct.add(UTF16, 24, "Name", null);
        struct.add(POINTER, this.psz, "StartAddress", null);
        struct.add(POINTER, this.psz, "EndAddress", null);
        struct.setCategoryPath(new CategoryPath("/PDMP"));
        return struct;
    }

    public int getNameLength() {
        return this.nameLength;
    }

    public void setNameLength(int nameLength) {
        this.nameLength = nameLength;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getStartAddress() {
        return this.startAddress;
    }

    public void setStartAddress(long startAddress) {
        this.startAddress = startAddress;
    }

    public long getEndAddress() {
        return this.endAddress;
    }

    public void setEndAddress(long endAddress) {
        this.endAddress = endAddress;
    }

    public long getSize() {
        long len = this.endAddress - this.startAddress;
        return len < 0L ? -len : len;
    }
}

