/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.DialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GIconLabel;
import docking.widgets.label.GLabel;
import generic.theme.GIcon;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class VersionControlDialog
extends DialogComponentProvider {
    private static final Icon ADD_ICON = new GIcon("icon.version.control.dialog.add");
    private static final Icon CHECK_IN_ICON = new GIcon("icon.version.control.dialog.check.in");
    static final int OK = 0;
    public static final int APPLY_TO_ALL = 1;
    public static final int CANCEL = 2;
    private JCheckBox keepCB;
    private JCheckBox keepFileCB;
    private JLabel descriptionLabel;
    private JTextArea commentsTextArea;
    private JButton allButton;
    private int actionID;
    private boolean addToVersionControl;

    public VersionControlDialog(boolean addToVersionControl) {
        super(addToVersionControl ? "Add File to Version Control" : "Check In File(s)", true);
        this.addToVersionControl = addToVersionControl;
        this.addWorkPanel(this.buildMainPanel());
        this.allButton = new JButton("Apply to All");
        this.allButton.getAccessibleContext().setAccessibleName("All");
        this.allButton.setMnemonic('A');
        this.allButton.addActionListener(e -> {
            this.actionID = 1;
            this.close();
        });
        this.addOKButton();
        this.addButton(this.allButton);
        this.addCancelButton();
        String tag = addToVersionControl ? "Add_to_Version_Control" : "CheckIn";
        this.setHelpLocation(new HelpLocation("Repository", tag));
        this.setRememberLocation(false);
        this.setRememberSize(false);
    }

    protected void cancelCallback() {
        this.actionID = 2;
        this.close();
    }

    protected void okCallback() {
        this.actionID = 0;
        this.close();
    }

    int showDialog(PluginTool tool, Component parent) {
        tool.showDialog((DialogComponentProvider)this, parent);
        return this.actionID;
    }

    void setMultiFiles(boolean multi) {
        this.allButton.setEnabled(multi);
    }

    boolean keepCheckedOut() {
        return this.keepCB.isSelected();
    }

    void setKeepCheckedOut(boolean selected) {
        this.keepCB.setSelected(selected);
    }

    boolean shouldCreateKeepFile() {
        if (this.addToVersionControl) {
            return false;
        }
        return this.keepFileCB.isSelected();
    }

    String getComments() {
        return this.commentsTextArea.getText();
    }

    public void setKeepCheckboxEnabled(boolean enabled, boolean selected, String disabledMsg) {
        this.keepCB.setEnabled(enabled);
        this.keepCB.setSelected(selected);
        this.keepCB.setToolTipText(enabled ? "" : disabledMsg);
    }

    private JPanel buildMainPanel() {
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        innerPanel.getAccessibleContext().setAccessibleName("Version Control");
        Icon icon = this.addToVersionControl ? ADD_ICON : CHECK_IN_ICON;
        this.descriptionLabel = new GDLabel(this.addToVersionControl ? "Add comments to describe the file." : "Add comments to describe changes", 2);
        this.descriptionLabel.getAccessibleContext().setAccessibleName("Description");
        JPanel dPanel = new JPanel(new BorderLayout(10, 0));
        dPanel.add((Component)new GIconLabel(icon), "West");
        dPanel.add((Component)this.descriptionLabel, "Center");
        dPanel.getAccessibleContext().setAccessibleName("Description");
        JPanel cPanel = new JPanel(new BorderLayout());
        cPanel.add((Component)new GLabel("Comments:", 2));
        cPanel.getAccessibleContext().setAccessibleName("Comments");
        this.commentsTextArea = new JTextArea(4, 20);
        JScrollPane sp = new JScrollPane(this.commentsTextArea);
        sp.getAccessibleContext().setAccessibleName("Comment");
        this.keepCB = new GCheckBox("Keep File Checked Out", true);
        JPanel kPanel = new JPanel(new BorderLayout());
        kPanel.add((Component)this.keepCB, "West");
        kPanel.getAccessibleContext().setAccessibleName("Keep File");
        innerPanel.add(Box.createVerticalStrut(10));
        innerPanel.add(dPanel);
        innerPanel.add(Box.createVerticalStrut(5));
        innerPanel.add(cPanel);
        innerPanel.add(sp);
        innerPanel.add(Box.createVerticalStrut(5));
        innerPanel.add(kPanel);
        if (!this.addToVersionControl) {
            this.keepFileCB = new GCheckBox("Create \".keep\" file", false);
            JPanel kpPanel = new JPanel(new BorderLayout());
            kpPanel.add((Component)this.keepFileCB, "West");
            kpPanel.getAccessibleContext().setAccessibleName("Keep File");
            innerPanel.add(kpPanel);
        }
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        mainPanel.add(innerPanel);
        mainPanel.getAccessibleContext().setAccessibleName("Version Control");
        return mainPanel;
    }

    public void setCurrentFileName(String filename) {
        String description = this.addToVersionControl ? "Add comments to describe " + filename + "." : "Add comments to describe changes to " + filename + ".";
        this.descriptionLabel.setText(description);
    }
}

