/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.ref;

import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.Reference;
import sarif.export.ref.ExtReference;

public class ExtExternalReference
extends ExtReference {
    String name;
    String origImport;
    boolean isClass;
    boolean isFunction;
    String libLabel;
    String libAddr;
    String libExtAddr;

    public ExtExternalReference(ExternalReference ref) {
        super((Reference)ref);
        ExternalLocation extLoc = ref.getExternalLocation();
        String label = extLoc.getLabel();
        Address addr = extLoc.getAddress();
        Address extAddr = extLoc.getExternalSpaceAddress();
        this.name = extLoc.getParentNameSpace().getName(true);
        this.origImport = extLoc.getOriginalImportedName();
        this.isClass = extLoc.getClass() != null;
        boolean bl = this.isFunction = extLoc.getFunction() != null;
        if (label != null) {
            this.libLabel = label;
        }
        if (addr != null) {
            this.libAddr = addr.toString();
        }
        if (extAddr != null) {
            this.libExtAddr = extAddr.toString();
        }
    }
}

