/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CountLatch {
    private Sync sync = new Sync();

    public void increment() {
        this.sync.increment();
    }

    public void decrement() {
        this.sync.decrement();
    }

    public int getCount() {
        return this.sync.getCount();
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        Sync() {
            this.setState(0);
        }

        int getCount() {
            return this.getState();
        }

        void increment() {
            int nextCount;
            int count;
            while (!this.compareAndSetState(count = this.getState(), nextCount = count + 1)) {
            }
        }

        void decrement() {
            int nextCount;
            int count;
            do {
                if ((count = this.getState()) != 0) continue;
                return;
            } while (!this.compareAndSetState(count, nextCount = count - 1));
            this.releaseShared(0);
        }

        @Override
        protected boolean tryReleaseShared(int ignored) {
            return this.getState() == 0;
        }

        @Override
        protected int tryAcquireShared(int ignored) {
            return this.getState() == 0 ? 1 : -1;
        }
    }
}

