/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.css.Viewport;
import io.sf.carte.echosvg.css.engine.CSSContext;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.LengthManager;
import io.sf.carte.echosvg.css.engine.value.NumericDelegateValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class FontSizeManager
extends LengthManager {
    protected static final StringMap values = new StringMap();

    public StringMap getIdentifiers() {
        return values;
    }

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public String getPropertyName() {
        return "font-size";
    }

    @Override
    public int getPropertyType() {
        return 39;
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.MEDIUM_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case IDENT: {
                String s = lu.getStringValue().toLowerCase(Locale.ROOT).intern();
                Object v = values.get(s);
                if (v == null) {
                    throw this.createInvalidIdentifierDOMException(s);
                }
                return (Value)v;
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
        }
        return super.createValue(lu, engine);
    }

    @Override
    public Value createStringValue(CSSValue.Type type, String value, CSSEngine engine) throws DOMException {
        if (type != CSSValue.Type.IDENT) {
            throw this.createInvalidStringTypeDOMException(type);
        }
        Object v = values.get(value.toLowerCase(Locale.ROOT).intern());
        if (v == null) {
            throw this.createInvalidIdentifierDOMException(value);
        }
        return (Value)v;
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        CSSValue.Type pType;
        boolean doParentRelative;
        float scale;
        block48: {
            block47: {
                scale = 1.0f;
                doParentRelative = false;
                pType = value.getPrimitiveType();
                if (pType != CSSValue.Type.NUMERIC) break block47;
                switch (value.getUnitType()) {
                    case 0: 
                    case 3: {
                        return value;
                    }
                    case 8: {
                        float v = value.getFloatValue();
                        return new FloatValue(3, v * 3.7795277f);
                    }
                    case 7: {
                        float v = value.getFloatValue();
                        return new FloatValue(3, v * 37.795277f);
                    }
                    case 4: {
                        float v = value.getFloatValue();
                        return new FloatValue(3, v * 96.0f);
                    }
                    case 6: {
                        float v = value.getFloatValue();
                        return new FloatValue(3, v / 0.75f);
                    }
                    case 5: {
                        float v = value.getFloatValue();
                        return new FloatValue(3, v * 16.0f);
                    }
                    case 20: {
                        doParentRelative = true;
                        scale = value.getFloatValue();
                        break block48;
                    }
                    case 21: {
                        doParentRelative = true;
                        scale = value.getFloatValue() * 0.5f;
                        break block48;
                    }
                    case 2: {
                        doParentRelative = true;
                        scale = value.getFloatValue() * 0.01f;
                        break block48;
                    }
                    case 25: {
                        float lh;
                        sm.putLineHeightRelative(idx, true);
                        scale = value.getFloatValue();
                        int lhidx = engine.getLineHeightIndex();
                        CSSStylableElement p = CSSEngine.getParentCSSStylableElement(elt);
                        if (p == null) {
                            lh = 1.1f * engine.getCSSContext().getMediumFontSize();
                        } else {
                            Value cs = engine.getComputedStyle(p, null, lhidx);
                            lh = this.lineHeightValue(p, null, engine, cs);
                        }
                        return new FloatValue(3, lh * scale);
                    }
                    case 26: {
                        sm.putRootFontSizeRelative(idx, true);
                        scale = value.getFloatValue();
                        return this.rootRelative(elt, engine, idx, scale);
                    }
                    case 28: {
                        sm.putRootFontSizeRelative(idx, true);
                        scale = value.getFloatValue() * 0.5f;
                        return this.rootRelative(elt, engine, idx, scale);
                    }
                    case 27: {
                        float lh;
                        sm.putLineHeightRelative(idx, true);
                        scale = value.getFloatValue();
                        int lhidx = engine.getLineHeightIndex();
                        CSSStylableElement root = (CSSStylableElement)elt.getOwnerDocument().getDocumentElement();
                        if (elt == root) {
                            lh = 1.1f * engine.getCSSContext().getMediumFontSize();
                        } else {
                            Value cs = engine.getComputedStyle(root, null, lhidx);
                            lh = this.lineHeightValue(root, null, engine, cs);
                        }
                        return new FloatValue(3, lh * scale);
                    }
                    case 45: {
                        sm.putViewportRelative(idx, true);
                        float v = value.getFloatValue();
                        return new FloatValue(3, v * engine.getCSSContext().getViewport(elt).getWidth() * 0.01f);
                    }
                    case 41: {
                        sm.putViewportRelative(idx, true);
                        float v = value.getFloatValue();
                        return new FloatValue(3, v * engine.getCSSContext().getViewport(elt).getHeight() * 0.01f);
                    }
                    case 44: {
                        sm.putViewportRelative(idx, true);
                        float v = value.getFloatValue();
                        Viewport vp = engine.getCSSContext().getViewport(elt);
                        float w = vp.getWidth();
                        float h = vp.getHeight();
                        float min = Math.min(w, h);
                        return new FloatValue(3, v * min * 0.01f);
                    }
                    case 43: {
                        sm.putViewportRelative(idx, true);
                        float v = value.getFloatValue();
                        Viewport vp = engine.getCSSContext().getViewport(elt);
                        float w = vp.getWidth();
                        float h = vp.getHeight();
                        float max = Math.max(w, h);
                        return new FloatValue(3, v * max * 0.01f);
                    }
                    default: {
                        return new FloatValue(3, NumberValue.floatValueConversion((float)value.getFloatValue(), (short)value.getUnitType(), (short)3));
                    }
                }
            }
            if (pType == CSSValue.Type.EXPRESSION || pType == CSSValue.Type.MATH_FUNCTION) {
                try {
                    Value calc = this.evaluateMath((NumericDelegateValue)value, elt, pseudo, engine, idx, sm, (short)3);
                    return new FloatValue(3, calc.getFloatValue());
                }
                catch (Exception e) {
                    return this.isInheritedProperty() ? null : this.getDefaultValue();
                }
            }
        }
        if (value.isIdentifier("larger")) {
            doParentRelative = true;
            scale = 1.2f;
        } else if (value.isIdentifier("smaller")) {
            doParentRelative = true;
            scale = 0.8333333f;
        }
        if (doParentRelative) {
            float fs;
            sm.putParentRelative(idx, true);
            CSSStylableElement p = CSSEngine.getParentCSSStylableElement(elt);
            if (p == null) {
                CSSContext ctx = engine.getCSSContext();
                fs = ctx.getMediumFontSize();
            } else {
                Value cs = engine.getComputedStyle(p, null, idx);
                fs = cs.getFloatValue();
            }
            return new FloatValue(3, fs * scale);
        }
        CSSContext ctx = engine.getCSSContext();
        float fs = ctx.getMediumFontSize();
        if (pType == CSSValue.Type.IDENT) {
            String s = value.getIdentifierValue();
            block20 : switch (s.charAt(0)) {
                case 'm': {
                    break;
                }
                case 's': {
                    fs /= 1.2f;
                    break;
                }
                case 'l': {
                    fs *= 1.2f;
                    break;
                }
                default: {
                    switch (s.charAt(1)) {
                        case 'x': {
                            switch (s.charAt(3)) {
                                case 's': {
                                    fs /= 1.728f;
                                    break block20;
                                }
                            }
                            fs *= 1.728f;
                            break block20;
                        }
                    }
                    switch (s.charAt(2)) {
                        case 's': {
                            fs /= 1.44f;
                            break block20;
                        }
                    }
                    fs *= 1.44f;
                }
            }
        }
        return new FloatValue(3, fs);
    }

    private Value rootRelative(CSSStylableElement elt, CSSEngine engine, int idx, float scale) {
        CSSStylableElement root = (CSSStylableElement)elt.getOwnerDocument().getDocumentElement();
        if (elt == root) {
            CSSContext ctx = engine.getCSSContext();
            float f = ctx.getMediumFontSize() * scale;
            return new FloatValue(3, f);
        }
        Value cs = engine.getComputedStyle(root, null, idx);
        float f = cs.getFloatValue() * scale;
        return new FloatValue(3, f);
    }

    @Override
    protected int getOrientation() {
        return 1;
    }

    static {
        values.put("all", ValueConstants.ALL_VALUE);
        values.put("large", ValueConstants.LARGE_VALUE);
        values.put("larger", ValueConstants.LARGER_VALUE);
        values.put("medium", ValueConstants.MEDIUM_VALUE);
        values.put("small", ValueConstants.SMALL_VALUE);
        values.put("smaller", ValueConstants.SMALLER_VALUE);
        values.put("x-large", ValueConstants.X_LARGE_VALUE);
        values.put("x-small", ValueConstants.X_SMALL_VALUE);
        values.put("xx-large", ValueConstants.XX_LARGE_VALUE);
        values.put("xx-small", ValueConstants.XX_SMALL_VALUE);
    }
}

