/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util.logging.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.freeplane.core.util.logging.LogHandlers;

public class LoggingOutputStream
extends ByteArrayOutputStream {
    public static final String STREAM_LOGGER_NAME = LoggingOutputStream.class.getName();
    private final Level level;
    private final String lineSeparator;
    private int availableSpace;
    private final PrintStream out;

    LoggingOutputStream(Level level, PrintStream out, int maximumLogSize) {
        this.out = out;
        this.level = level;
        this.availableSpace = maximumLogSize;
        this.lineSeparator = System.getProperty("line.separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        String record;
        this.out.flush();
        LoggingOutputStream loggingOutputStream = this;
        synchronized (loggingOutputStream) {
            super.flush();
            record = this.toString();
            super.reset();
        }
        if (record.length() == 0 || record.equals(this.lineSeparator)) {
            return;
        }
        Collection<Handler> handlers = LogHandlers.getHandlers();
        LogRecord logRecord = new LogRecord(this.level, record);
        logRecord.setLoggerName(STREAM_LOGGER_NAME);
        for (Handler handler : handlers) {
            handler.publish(logRecord);
        }
    }

    @Override
    public synchronized void write(int b) {
        this.out.write(b);
        if (this.availableSpace > 0) {
            --this.availableSpace;
            super.write(b);
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        this.out.write(b, off, len);
        if (this.availableSpace > 0) {
            this.availableSpace -= len;
            super.write(b, off, len);
        }
    }
}

