/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.enumeration;

import org.freeplane.core.enumeration.DefaultValueSupplier;
import org.freeplane.core.enumeration.OnceForMap;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IExtensionAttributeWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.features.map.NodeModel;

public class NodeEnumerationAttributeHandler<T extends Enum<T> & IExtension>
implements IAttributeHandler,
IExtensionAttributeWriter {
    private final Class<T> enumClass;
    private final boolean onceForMap;

    public NodeEnumerationAttributeHandler(Class<T> enumClass) {
        this.enumClass = enumClass;
        this.onceForMap = enumClass.getAnnotation(OnceForMap.class) != null;
    }

    public void registerBy(ReadManager readManager, WriteManager writeManager) {
        String attributeName = this.attributeName();
        readManager.addAttributeHandler("node", attributeName, this);
        readManager.addAttributeHandler("stylenode", attributeName, this);
        writeManager.addExtensionAttributeWriter(this.enumClass, this);
    }

    private String attributeName() {
        return this.enumClass.getSimpleName();
    }

    @Override
    public void setAttribute(Object object, String value) {
        NodeModel node = (NodeModel)object;
        if (!this.onceForMap || node.isRoot()) {
            node.addExtension((IExtension)Enum.valueOf(this.enumClass, value));
        }
    }

    @Override
    public void writeAttributes(ITreeWriter writer, Object userObject, IExtension extension) {
        Enum value = (Enum)((Object)extension);
        if (!value.equals(((DefaultValueSupplier)((Object)value)).getDefaultValue())) {
            writer.addAttribute(this.attributeName(), value.name());
        }
    }
}

