/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class BatchRequestResponse {
    private BatchRequestResponse() {
    }

    public record BatchFileRequest<REQ>(String key, REQ request) {
    }

    record ListOperationsResponse<RESP>(List<Operation<RESP>> operations, String nextPageToken) {
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    record Operation<RESP>(String name, Map<String, Object> metadata, boolean done, Status error, BatchCreateResponse<RESP> response) {

        @JsonIgnoreProperties(ignoreUnknown=true)
        public record Status(int code, String message, List<Map<String, Object>> details) {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    record BatchCreateResponse<RESP>(@JsonProperty(value="@type") String type, InlinedResponses<RESP> inlinedResponses) {

        @JsonIgnoreProperties(ignoreUnknown=true)
        record InlinedResponses<RESP>(List<InlinedResponseWrapper<RESP>> inlinedResponses) {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        record InlinedResponseWrapper<RESP>(RESP response) {
        }
    }

    record BatchCreateFileRequest(FileBatch batch) {

        record FileBatch(@JsonProperty(value="display_name") String displayName, @JsonProperty(value="input_config") FileInputConfig inputConfig) {
        }

        record FileInputConfig(@JsonProperty(value="file_name") String fileName) {
        }
    }

    record BatchCreateRequest<REQ>(Batch<REQ> batch) {

        record Batch<REQ>(@JsonProperty(value="display_name") String displayName, @JsonProperty(value="input_config") InputConfig<REQ> inputConfig, long priority) {
        }

        record InlinedRequest<REQ>(REQ request, Map<String, String> metadata) {
        }

        record Requests<REQ>(List<InlinedRequest<REQ>> requests) {
        }

        record InputConfig<REQ>(Requests<REQ> requests) {
        }
    }

    public static enum BatchJobState {
        BATCH_STATE_PENDING,
        BATCH_STATE_RUNNING,
        BATCH_STATE_SUCCEEDED,
        BATCH_STATE_FAILED,
        BATCH_STATE_CANCELLED,
        BATCH_STATE_EXPIRED,
        UNSPECIFIED;

    }

    public record BatchName(String value) {
        public BatchName {
            BatchName.ensureOperationNameFormat(value);
        }

        private static void ensureOperationNameFormat(String operationName) {
            if (!operationName.startsWith("batches/")) {
                throw new IllegalArgumentException("Batch name must start with 'batches/'. This name is returned when creating the batch with #createBatchInline.");
            }
        }
    }

    public record BatchList<T>(String pageToken, List<BatchResponse<T>> responses) {
    }

    public record BatchError<T>(BatchName batchName, int code, String message, BatchJobState state, List<Map<String, Object>> details) implements BatchResponse<T>
    {
    }

    public record BatchSuccess<T>(BatchName batchName, List<T> responses) implements BatchResponse<T>
    {
    }

    public record BatchIncomplete<T>(BatchName batchName, BatchJobState state) implements BatchResponse<T>
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface BatchResponse<T> {
    }
}

