﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-voice/ChimeSDKVoiceRequest.h>
#include <aws/chime-sdk-voice/ChimeSDKVoice_EXPORTS.h>
#include <aws/chime-sdk-voice/model/Termination.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ChimeSDKVoice {
namespace Model {

/**
 */
class PutVoiceConnectorTerminationRequest : public ChimeSDKVoiceRequest {
 public:
  AWS_CHIMESDKVOICE_API PutVoiceConnectorTerminationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "PutVoiceConnectorTermination"; }

  AWS_CHIMESDKVOICE_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The Voice Connector ID.</p>
   */
  inline const Aws::String& GetVoiceConnectorId() const { return m_voiceConnectorId; }
  inline bool VoiceConnectorIdHasBeenSet() const { return m_voiceConnectorIdHasBeenSet; }
  template <typename VoiceConnectorIdT = Aws::String>
  void SetVoiceConnectorId(VoiceConnectorIdT&& value) {
    m_voiceConnectorIdHasBeenSet = true;
    m_voiceConnectorId = std::forward<VoiceConnectorIdT>(value);
  }
  template <typename VoiceConnectorIdT = Aws::String>
  PutVoiceConnectorTerminationRequest& WithVoiceConnectorId(VoiceConnectorIdT&& value) {
    SetVoiceConnectorId(std::forward<VoiceConnectorIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The termination settings to be updated.</p>
   */
  inline const Termination& GetTermination() const { return m_termination; }
  inline bool TerminationHasBeenSet() const { return m_terminationHasBeenSet; }
  template <typename TerminationT = Termination>
  void SetTermination(TerminationT&& value) {
    m_terminationHasBeenSet = true;
    m_termination = std::forward<TerminationT>(value);
  }
  template <typename TerminationT = Termination>
  PutVoiceConnectorTerminationRequest& WithTermination(TerminationT&& value) {
    SetTermination(std::forward<TerminationT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_voiceConnectorId;

  Termination m_termination;
  bool m_voiceConnectorIdHasBeenSet = false;
  bool m_terminationHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKVoice
}  // namespace Aws
