﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent/BedrockAgent_EXPORTS.h>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace BedrockAgent {
namespace Model {

/**
 * <p>Defines tools. The model automatically decides whether to call a tool or to
 * generate text instead. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html">Use a
 * tool to complete an Amazon Bedrock model response</a>.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/AutoToolChoice">AWS
 * API Reference</a></p>
 */
class AutoToolChoice {
 public:
  AWS_BEDROCKAGENT_API AutoToolChoice() = default;
  AWS_BEDROCKAGENT_API AutoToolChoice(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENT_API AutoToolChoice& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENT_API Aws::Utils::Json::JsonValue Jsonize() const;
};

}  // namespace Model
}  // namespace BedrockAgent
}  // namespace Aws
