﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/wellarchitected/WellArchitected_EXPORTS.h>
#include <aws/wellarchitected/model/ProfileQuestion.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WellArchitected {
namespace Model {

/**
 * <p>A profile.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/Profile">AWS
 * API Reference</a></p>
 */
class Profile {
 public:
  AWS_WELLARCHITECTED_API Profile() = default;
  AWS_WELLARCHITECTED_API Profile(Aws::Utils::Json::JsonView jsonValue);
  AWS_WELLARCHITECTED_API Profile& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WELLARCHITECTED_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The profile ARN.</p>
   */
  inline const Aws::String& GetProfileArn() const { return m_profileArn; }
  inline bool ProfileArnHasBeenSet() const { return m_profileArnHasBeenSet; }
  template <typename ProfileArnT = Aws::String>
  void SetProfileArn(ProfileArnT&& value) {
    m_profileArnHasBeenSet = true;
    m_profileArn = std::forward<ProfileArnT>(value);
  }
  template <typename ProfileArnT = Aws::String>
  Profile& WithProfileArn(ProfileArnT&& value) {
    SetProfileArn(std::forward<ProfileArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The profile version.</p>
   */
  inline const Aws::String& GetProfileVersion() const { return m_profileVersion; }
  inline bool ProfileVersionHasBeenSet() const { return m_profileVersionHasBeenSet; }
  template <typename ProfileVersionT = Aws::String>
  void SetProfileVersion(ProfileVersionT&& value) {
    m_profileVersionHasBeenSet = true;
    m_profileVersion = std::forward<ProfileVersionT>(value);
  }
  template <typename ProfileVersionT = Aws::String>
  Profile& WithProfileVersion(ProfileVersionT&& value) {
    SetProfileVersion(std::forward<ProfileVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The profile name.</p>
   */
  inline const Aws::String& GetProfileName() const { return m_profileName; }
  inline bool ProfileNameHasBeenSet() const { return m_profileNameHasBeenSet; }
  template <typename ProfileNameT = Aws::String>
  void SetProfileName(ProfileNameT&& value) {
    m_profileNameHasBeenSet = true;
    m_profileName = std::forward<ProfileNameT>(value);
  }
  template <typename ProfileNameT = Aws::String>
  Profile& WithProfileName(ProfileNameT&& value) {
    SetProfileName(std::forward<ProfileNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The profile description.</p>
   */
  inline const Aws::String& GetProfileDescription() const { return m_profileDescription; }
  inline bool ProfileDescriptionHasBeenSet() const { return m_profileDescriptionHasBeenSet; }
  template <typename ProfileDescriptionT = Aws::String>
  void SetProfileDescription(ProfileDescriptionT&& value) {
    m_profileDescriptionHasBeenSet = true;
    m_profileDescription = std::forward<ProfileDescriptionT>(value);
  }
  template <typename ProfileDescriptionT = Aws::String>
  Profile& WithProfileDescription(ProfileDescriptionT&& value) {
    SetProfileDescription(std::forward<ProfileDescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Profile questions.</p>
   */
  inline const Aws::Vector<ProfileQuestion>& GetProfileQuestions() const { return m_profileQuestions; }
  inline bool ProfileQuestionsHasBeenSet() const { return m_profileQuestionsHasBeenSet; }
  template <typename ProfileQuestionsT = Aws::Vector<ProfileQuestion>>
  void SetProfileQuestions(ProfileQuestionsT&& value) {
    m_profileQuestionsHasBeenSet = true;
    m_profileQuestions = std::forward<ProfileQuestionsT>(value);
  }
  template <typename ProfileQuestionsT = Aws::Vector<ProfileQuestion>>
  Profile& WithProfileQuestions(ProfileQuestionsT&& value) {
    SetProfileQuestions(std::forward<ProfileQuestionsT>(value));
    return *this;
  }
  template <typename ProfileQuestionsT = ProfileQuestion>
  Profile& AddProfileQuestions(ProfileQuestionsT&& value) {
    m_profileQuestionsHasBeenSet = true;
    m_profileQuestions.emplace_back(std::forward<ProfileQuestionsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetOwner() const { return m_owner; }
  inline bool OwnerHasBeenSet() const { return m_ownerHasBeenSet; }
  template <typename OwnerT = Aws::String>
  void SetOwner(OwnerT&& value) {
    m_ownerHasBeenSet = true;
    m_owner = std::forward<OwnerT>(value);
  }
  template <typename OwnerT = Aws::String>
  Profile& WithOwner(OwnerT&& value) {
    SetOwner(std::forward<OwnerT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  inline bool CreatedAtHasBeenSet() const { return m_createdAtHasBeenSet; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  Profile& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Utils::DateTime& GetUpdatedAt() const { return m_updatedAt; }
  inline bool UpdatedAtHasBeenSet() const { return m_updatedAtHasBeenSet; }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  void SetUpdatedAt(UpdatedAtT&& value) {
    m_updatedAtHasBeenSet = true;
    m_updatedAt = std::forward<UpdatedAtT>(value);
  }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  Profile& WithUpdatedAt(UpdatedAtT&& value) {
    SetUpdatedAt(std::forward<UpdatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID assigned to the share invitation.</p>
   */
  inline const Aws::String& GetShareInvitationId() const { return m_shareInvitationId; }
  inline bool ShareInvitationIdHasBeenSet() const { return m_shareInvitationIdHasBeenSet; }
  template <typename ShareInvitationIdT = Aws::String>
  void SetShareInvitationId(ShareInvitationIdT&& value) {
    m_shareInvitationIdHasBeenSet = true;
    m_shareInvitationId = std::forward<ShareInvitationIdT>(value);
  }
  template <typename ShareInvitationIdT = Aws::String>
  Profile& WithShareInvitationId(ShareInvitationIdT&& value) {
    SetShareInvitationId(std::forward<ShareInvitationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tags assigned to the profile.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  Profile& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  Profile& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_profileArn;

  Aws::String m_profileVersion;

  Aws::String m_profileName;

  Aws::String m_profileDescription;

  Aws::Vector<ProfileQuestion> m_profileQuestions;

  Aws::String m_owner;

  Aws::Utils::DateTime m_createdAt{};

  Aws::Utils::DateTime m_updatedAt{};

  Aws::String m_shareInvitationId;

  Aws::Map<Aws::String, Aws::String> m_tags;
  bool m_profileArnHasBeenSet = false;
  bool m_profileVersionHasBeenSet = false;
  bool m_profileNameHasBeenSet = false;
  bool m_profileDescriptionHasBeenSet = false;
  bool m_profileQuestionsHasBeenSet = false;
  bool m_ownerHasBeenSet = false;
  bool m_createdAtHasBeenSet = false;
  bool m_updatedAtHasBeenSet = false;
  bool m_shareInvitationIdHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
};

}  // namespace Model
}  // namespace WellArchitected
}  // namespace Aws
