/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.listeners;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.featuresSuggester.SuggesterSupport;
import training.featuresSuggester.SuggestingUtils;
import training.featuresSuggester.actions.BeforeChildAddedAction;
import training.featuresSuggester.actions.BeforeChildMovedAction;
import training.featuresSuggester.actions.BeforeChildRemovedAction;
import training.featuresSuggester.actions.BeforeChildReplacedAction;
import training.featuresSuggester.actions.BeforeChildrenChangedAction;
import training.featuresSuggester.actions.BeforePropertyChangedAction;
import training.featuresSuggester.actions.ChildAddedAction;
import training.featuresSuggester.actions.ChildMovedAction;
import training.featuresSuggester.actions.ChildRemovedAction;
import training.featuresSuggester.actions.ChildReplacedAction;
import training.featuresSuggester.actions.ChildrenChangedAction;
import training.featuresSuggester.actions.PropertyChangedAction;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ltraining/featuresSuggester/listeners/PsiActionsListener;", "Lcom/intellij/psi/PsiTreeChangeAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "beforePropertyChange", "", "event", "Lcom/intellij/psi/PsiTreeChangeEvent;", "beforeChildAddition", "beforeChildReplacement", "beforeChildrenChange", "beforeChildMovement", "beforeChildRemoval", "propertyChanged", "childRemoved", "childReplaced", "childAdded", "childrenChanged", "childMoved", "isLoadedSourceFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.featuresTrainer"})
public final class PsiActionsListener
extends PsiTreeChangeAdapter {
    @NotNull
    private final Project project;

    public PsiActionsListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        SuggestingUtils.INSTANCE.handleAction(this.project, new BeforePropertyChangedAction(psiFile, psiElement, System.currentTimeMillis()));
    }

    public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || event.getChild() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        PsiElement psiElement2 = event.getChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getChild(...)");
        SuggestingUtils.INSTANCE.handleAction(this.project, new BeforeChildAddedAction(psiFile, psiElement, psiElement2, System.currentTimeMillis()));
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || event.getNewChild() == null || event.getOldChild() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        PsiElement psiElement2 = event.getNewChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getNewChild(...)");
        PsiElement psiElement3 = event.getOldChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getOldChild(...)");
        SuggestingUtils.INSTANCE.handleAction(this.project, new BeforeChildReplacedAction(psiFile, psiElement, psiElement2, psiElement3, System.currentTimeMillis()));
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        SuggestingUtils.INSTANCE.handleAction(this.project, new BeforeChildrenChangedAction(psiFile, psiElement, System.currentTimeMillis()));
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || event.getChild() == null || event.getOldParent() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        PsiElement psiElement2 = event.getChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getChild(...)");
        PsiElement psiElement3 = event.getOldParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getOldParent(...)");
        SuggestingUtils.INSTANCE.handleAction(this.project, new BeforeChildMovedAction(psiFile, psiElement, psiElement2, psiElement3, System.currentTimeMillis()));
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || event.getChild() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        PsiElement psiElement2 = event.getChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getChild(...)");
        SuggestingUtils.INSTANCE.handleAction(this.project, new BeforeChildRemovedAction(psiFile, psiElement, psiElement2, System.currentTimeMillis()));
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        SuggestingUtils.INSTANCE.handleAction(this.project, new PropertyChangedAction(psiFile, psiElement, System.currentTimeMillis()));
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || event.getChild() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        PsiElement psiElement2 = event.getChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getChild(...)");
        SuggestingUtils.INSTANCE.handleAction(this.project, new ChildRemovedAction(psiFile, psiElement, psiElement2, System.currentTimeMillis()));
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || event.getNewChild() == null || event.getOldChild() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        PsiElement psiElement2 = event.getNewChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getNewChild(...)");
        PsiElement psiElement3 = event.getOldChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getOldChild(...)");
        SuggestingUtils.INSTANCE.handleAction(this.project, new ChildReplacedAction(psiFile, psiElement, psiElement2, psiElement3, System.currentTimeMillis()));
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || event.getChild() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        PsiElement psiElement2 = event.getChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getChild(...)");
        SuggestingUtils.INSTANCE.handleAction(this.project, new ChildAddedAction(psiFile, psiElement, psiElement2, System.currentTimeMillis()));
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        SuggestingUtils.INSTANCE.handleAction(this.project, new ChildrenChangedAction(psiFile, psiElement, System.currentTimeMillis()));
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || event.getChild() == null || event.getOldParent() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        PsiElement psiElement2 = event.getChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getChild(...)");
        PsiElement psiElement3 = event.getOldParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getOldParent(...)");
        SuggestingUtils.INSTANCE.handleAction(this.project, new ChildMovedAction(psiFile, psiElement, psiElement2, psiElement3, System.currentTimeMillis()));
    }

    private final boolean isLoadedSourceFile(PsiFile psiFile) {
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null || (psiFile2 = psiFile2.getLanguage()) == null) {
            return false;
        }
        PsiFile language = psiFile2;
        SuggesterSupport suggesterSupport = SuggesterSupport.Companion.getForLanguage((Language)language);
        return suggesterSupport != null ? suggesterSupport.isLoadedSourceFile(psiFile) : false;
    }
}

