/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger;

import com.intellij.rt.debugger.JsonUtils;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class MetadataDebugHelper {
    public static final String METADATA_SEPARATOR = "\n";
    private static final String METADATA_CLASS_NAME = "kotlin.Metadata";
    private static final String KIND = "kind";
    private static final String METADATA_VERSION = "metadataVersion";
    private static final String DATA_1 = "data1";
    private static final String DATA_2 = "data2";
    private static final String EXTRA_STRING = "extraString";
    private static final String PACKAGE_NAME = "packageName";
    private static final String EXTRA_INT = "extraInt";
    private static final String KIND_METHOD_NAME = "k";
    private static final String METADATA_VERSION_METHOD_NAME = "mv";
    private static final String DATA_1_METHOD_NAME = "d1";
    private static final String DATA_2_METHOD_NAME = "d2";
    private static final String EXTRA_STRING_METHOD_NAME = "xs";
    private static final String PACKAGE_NAME_METHOD_NAME = "pn";
    private static final String EXTRA_INT_METHOD_NAME = "xi";

    public static String getDebugMetadataAsJson(Class<?> cls) {
        StringBuilder sb = new StringBuilder();
        MetadataDebugHelper.appendDebugMetadataAsJson(sb, cls);
        return sb.toString();
    }

    private static void appendDebugMetadataAsJson(StringBuilder sb, Class<?> cls) {
        try {
            Class<?> metadataClass = Class.forName(METADATA_CLASS_NAME, false, cls.getClassLoader());
            Method kindMethod = metadataClass.getDeclaredMethod(KIND_METHOD_NAME, new Class[0]);
            Method metadataVersionMethod = metadataClass.getDeclaredMethod(METADATA_VERSION_METHOD_NAME, new Class[0]);
            Method data1Method = metadataClass.getDeclaredMethod(DATA_1_METHOD_NAME, new Class[0]);
            Method data2Method = metadataClass.getDeclaredMethod(DATA_2_METHOD_NAME, new Class[0]);
            Method extraStringMethod = metadataClass.getDeclaredMethod(EXTRA_STRING_METHOD_NAME, new Class[0]);
            Method packageNameMethod = metadataClass.getDeclaredMethod(PACKAGE_NAME_METHOD_NAME, new Class[0]);
            Method extraIntMethod = metadataClass.getDeclaredMethod(EXTRA_INT_METHOD_NAME, new Class[0]);
            Object metadata = cls.getAnnotation(metadataClass);
            sb.append("{");
            int kind = (Integer)kindMethod.invoke(metadata, new Object[0]);
            MetadataDebugHelper.appendAsJsonValue(sb, KIND, kind);
            int[] metadataVersion = (int[])metadataVersionMethod.invoke(metadata, new Object[0]);
            MetadataDebugHelper.appendAsJsonValue(sb, METADATA_VERSION, Arrays.toString(metadataVersion));
            String[] data1 = (String[])data1Method.invoke(metadata, new Object[0]);
            MetadataDebugHelper.appendAsJsonValue(sb, DATA_1, Arrays.toString(MetadataDebugHelper.toJsonBase64Encoded(data1)));
            String[] data2 = (String[])data2Method.invoke(metadata, new Object[0]);
            MetadataDebugHelper.appendAsJsonValue(sb, DATA_2, Arrays.toString(MetadataDebugHelper.toJson(data2)));
            String extraString = (String)extraStringMethod.invoke(metadata, new Object[0]);
            MetadataDebugHelper.appendAsJsonValue(sb, EXTRA_STRING, MetadataDebugHelper.toJson(extraString));
            String packageName = (String)packageNameMethod.invoke(metadata, new Object[0]);
            MetadataDebugHelper.appendAsJsonValue(sb, PACKAGE_NAME, MetadataDebugHelper.toJson(packageName));
            int extraInt = (Integer)extraIntMethod.invoke(metadata, new Object[0]);
            MetadataDebugHelper.appendAsJsonValueNoComma(sb, EXTRA_INT, extraInt);
            sb.append("}");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getDebugMetadataListAsJson(Class<?> ... classes) {
        StringBuilder sb = new StringBuilder();
        for (Class<?> cls : classes) {
            if (sb.length() != 0) {
                sb.append(METADATA_SEPARATOR);
            }
            MetadataDebugHelper.appendDebugMetadataAsJson(sb, cls);
        }
        return sb.toString();
    }

    private static void appendAsJsonValue(StringBuilder sb, String name, Object value) {
        MetadataDebugHelper.appendAsJsonValueNoComma(sb, name, value).append(',');
    }

    private static StringBuilder appendAsJsonValueNoComma(StringBuilder sb, String name, Object value) {
        return sb.append(MetadataDebugHelper.toJson(name)).append(':').append(value);
    }

    private static String toJson(String str) {
        return "\"" + JsonUtils.escapeJsonString(str) + "\"";
    }

    private static String[] toJson(String[] array) {
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = MetadataDebugHelper.toJson(array[i]);
        }
        return result;
    }

    private static String[] toJsonBase64Encoded(String[] array) throws Exception {
        Class<?> base64Class = Class.forName("java.util.Base64");
        Method getEncoding = base64Class.getDeclaredMethod("getEncoder", new Class[0]);
        Object encoder = getEncoding.invoke(base64Class, new Object[0]);
        Class<?> encoderClass = Class.forName("java.util.Base64$Encoder");
        Method encodeToString = encoderClass.getDeclaredMethod("encodeToString", byte[].class);
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            byte[] bytes = array[i].getBytes(StandardCharsets.UTF_8);
            String encoded = (String)encodeToString.invoke(encoder, new Object[]{bytes});
            result[i] = MetadataDebugHelper.toJson(encoded);
        }
        return result;
    }
}

