/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.buildScriptClasspathModel;

import com.intellij.gradle.toolingExtension.impl.model.buildScriptClasspathModel.DefaultGradleBuildScriptClasspathModel;
import com.intellij.gradle.toolingExtension.impl.util.GradleProjectUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.Project;
import org.gradle.tooling.model.ProjectIdentifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.GradleBuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;

@ApiStatus.Internal
public class GradleBuildScriptClasspathCache {
    @NotNull
    private final ModelBuilderContext context;
    @NotNull
    private final ConcurrentMap<ProjectIdentifier, GradleBuildScriptClasspathModel> models;
    @NotNull
    private static final ModelBuilderContext.DataProvider<GradleBuildScriptClasspathCache> INSTANCE_PROVIDER = GradleBuildScriptClasspathCache::new;

    private GradleBuildScriptClasspathCache(@NotNull ModelBuilderContext context) {
        if (context == null) {
            GradleBuildScriptClasspathCache.$$$reportNull$$$0(0);
        }
        this.context = context;
        this.models = new ConcurrentHashMap<ProjectIdentifier, GradleBuildScriptClasspathModel>();
    }

    @NotNull
    public GradleBuildScriptClasspathModel getBuildScriptClasspathModel(@NotNull Project project) {
        ProjectIdentifier projectIdentifier;
        GradleBuildScriptClasspathModel model;
        if (project == null) {
            GradleBuildScriptClasspathCache.$$$reportNull$$$0(1);
        }
        if ((model = (GradleBuildScriptClasspathModel)this.models.get(projectIdentifier = GradleProjectUtil.getProjectIdentifier(project))) == null) {
            String projectDisplayName = project.getDisplayName();
            this.context.getMessageReporter().createMessage().withGroup("gradle.buildScriptClasspathModel.cacheGet.group").withTitle("Gradle build script class-path model aren't found").withText("Gradle build script class-path model for " + projectDisplayName + " wasn't collected.").withInternal().withStackTrace().withKind(Message.Kind.ERROR).reportMessage(project);
            return new DefaultGradleBuildScriptClasspathModel();
        }
        GradleBuildScriptClasspathModel gradleBuildScriptClasspathModel = model;
        if (gradleBuildScriptClasspathModel == null) {
            GradleBuildScriptClasspathCache.$$$reportNull$$$0(2);
        }
        return gradleBuildScriptClasspathModel;
    }

    public void setBuildScriptClasspathModel(@NotNull Project project, @NotNull GradleBuildScriptClasspathModel model) {
        ProjectIdentifier projectIdentifier;
        GradleBuildScriptClasspathModel oldModel;
        if (project == null) {
            GradleBuildScriptClasspathCache.$$$reportNull$$$0(3);
        }
        if (model == null) {
            GradleBuildScriptClasspathCache.$$$reportNull$$$0(4);
        }
        if ((oldModel = this.models.put(projectIdentifier = GradleProjectUtil.getProjectIdentifier(project), model)) != null) {
            String projectDisplayName = project.getDisplayName();
            this.context.getMessageReporter().createMessage().withGroup("gradle.buildScriptClasspathModel.cacheSet.group").withTitle("Gradle build script class-path model redefinition").withText("Gradle build script class-path model for " + projectDisplayName + " was already collected.").withInternal().withStackTrace().withKind(Message.Kind.ERROR).reportMessage(project);
        }
    }

    public void markBuildScriptClasspathModelAsError(@NotNull Project project) {
        if (project == null) {
            GradleBuildScriptClasspathCache.$$$reportNull$$$0(5);
        }
        ProjectIdentifier projectIdentifier = GradleProjectUtil.getProjectIdentifier(project);
        this.models.put(projectIdentifier, new DefaultGradleBuildScriptClasspathModel());
    }

    @NotNull
    public static GradleBuildScriptClasspathCache getInstance(@NotNull ModelBuilderContext context) {
        if (context == null) {
            GradleBuildScriptClasspathCache.$$$reportNull$$$0(6);
        }
        GradleBuildScriptClasspathCache gradleBuildScriptClasspathCache = (GradleBuildScriptClasspathCache)context.getData(INSTANCE_PROVIDER);
        if (gradleBuildScriptClasspathCache == null) {
            GradleBuildScriptClasspathCache.$$$reportNull$$$0(7);
        }
        return gradleBuildScriptClasspathCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/model/buildScriptClasspathModel/GradleBuildScriptClasspathCache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/buildScriptClasspathModel/GradleBuildScriptClasspathCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildScriptClasspathModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBuildScriptClasspathModel";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBuildScriptClasspathModel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markBuildScriptClasspathModelAsError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

